/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.ParticleTextureStitcher;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;

public abstract class ParticleFactory<F extends ParticleFactory<?, T>, T extends Particle> {
    private final ParticleTextureStitcher<T> stitcher;
    private final Class<T> type;
    private final ParticleArgs baseArgs;
    private final ParticleArgs defaultArgs;
    public static final Object EMPTY_ARG = new Object();
    private final BaseArgsBuilder baseArgsBuilder = new BaseArgsBuilder(this);

    public ParticleFactory(Class<T> type) {
        this(type, null);
    }

    public ParticleFactory(Class<T> type, @Nullable ParticleTextureStitcher<T> stitcher) {
        this.stitcher = stitcher;
        this.type = type;
        this.baseArgs = new ParticleArgs();
        this.setBaseArguments(this.baseArgs);
        this.defaultArgs = new ParticleArgs();
    }

    public final ParticleTextureStitcher<? extends Particle> getStitcher() {
        return this.stitcher;
    }

    public final Class<T> getType() {
        return this.type;
    }

    public static final void setParticleColor(Particle particle, int color) {
        particle.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        particle.func_82338_g((float)(color >> 24 & 0xFF) / 255.0f);
    }

    protected final T getParticle(ImmutableParticleArgs args) {
        T particle = this.createParticle(args);
        if (this.getStitcher() != null) {
            ((ParticleTextureStitcher.IParticleSpriteReceiver)particle).setStitchedSprites(this.getStitcher().getSprites());
        }
        ParticleFactory.setParticleColor(particle, args.color);
        return particle;
    }

    protected abstract T createParticle(ImmutableParticleArgs var1);

    protected void setBaseArguments(ParticleArgs args) {
    }

    protected void setDefaultArguments(World world, ParticleArgs args) {
    }

    public BaseArgsBuilder<F, BaseArgsBuilder<F, ?, T>, T> getBaseArgsBuilder() {
        this.baseArgsBuilder.reset();
        return this.baseArgsBuilder;
    }

    public final T create(World world, double x, double y, double z, @Nullable ParticleArgs args) {
        if (args == null) {
            args = ParticleArgs.get();
        }
        this.defaultArgs.reset();
        this.setDefaultArguments(world, this.defaultArgs);
        boolean hasActualDefaults = this.defaultArgs.isColorSet() || this.defaultArgs.isMotionSet() || this.defaultArgs.isScaleSet() || this.defaultArgs.isDataSet();
        args = hasActualDefaults ? this.baseArgs.populateEmptyArgs(this.defaultArgs).populateEmptyArgs(args) : this.baseArgs.populateEmptyArgs(args);
        return this.getParticle(new ImmutableParticleArgs(world, x, y, z, args));
    }

    public final T spawn(World world, double x, double y, double z, @Nullable ParticleArgs args) {
        T particle = this.create(world, x, y, z, args);
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
        return particle;
    }

    public static final class BaseArgsBuilder<F extends ParticleFactory, B extends BaseArgsBuilder, C extends Particle>
    extends ParticleArgs<B> {
        private final ParticleFactory factory;

        private BaseArgsBuilder(ParticleFactory factory) {
            this.factory = factory;
        }

        public final F buildBaseArgs() {
            ParticleArgs container = new ParticleArgs();
            this.populateEmptyArgs(container);
            this.factory.baseArgs.populateEmptyArgs(container);
            if (container.isMotionSet()) {
                this.factory.baseArgs.withMotion(container.getMotionX(), container.getMotionY(), container.getMotionZ());
            }
            if (container.isColorSet()) {
                this.factory.baseArgs.withColor(container.getColor());
            }
            if (container.isScaleSet()) {
                this.factory.baseArgs.withScale(container.getScale());
            }
            if (container.isDataSet()) {
                this.factory.baseArgs.withData(container.getData());
            }
            return (F)this.factory;
        }
    }

    public static class ParticleArgs<T extends ParticleArgs>
    implements Consumer<ParticleArgs> {
        private static final ParticleArgs BUILDER = new ParticleArgs();
        private static final Object[] NO_DATA = new Object[0];
        private boolean motionSet = false;
        private double motionX;
        private double motionY;
        private double motionZ;
        private boolean scaleSet = false;
        private float scale;
        private boolean colorSet = false;
        private int color;
        private Object[] data;
        private boolean dataSet = false;

        private ParticleArgs() {
            this.reset();
        }

        public final void reset() {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.scale = 1.0f;
            this.color = -1;
            this.data = NO_DATA;
            this.dataSet = false;
            this.motionSet = false;
            this.scaleSet = false;
            this.colorSet = false;
        }

        public final T accept(Consumer<ParticleArgs> consumer) {
            consumer.accept(this);
            return (T)this;
        }

        public final T withMotion(double motionX, double motionY, double motionZ) {
            this.motionX = motionX;
            this.motionY = motionY;
            this.motionZ = motionZ;
            this.motionSet = true;
            return (T)this;
        }

        public final T withScale(float scale) {
            this.scale = scale;
            this.scaleSet = true;
            return (T)this;
        }

        public final T withColor(int color) {
            this.color = color;
            this.colorSet = true;
            return (T)this;
        }

        public final T withData(Object ... data) {
            if (data == null) {
                data = NO_DATA;
            }
            this.data = data;
            this.dataSet = true;
            return (T)this;
        }

        public final ArgumentDataBuilder<T> withDataBuilder() {
            return new ArgumentDataBuilder(this, null);
        }

        public final double getMotionX() {
            return this.motionX;
        }

        public final double getMotionY() {
            return this.motionY;
        }

        public final double getMotionZ() {
            return this.motionZ;
        }

        public final boolean isMotionSet() {
            return this.motionSet;
        }

        public final float getScale() {
            return this.scale;
        }

        public final boolean isScaleSet() {
            return this.scaleSet;
        }

        public final int getColor() {
            return this.color;
        }

        public final boolean isColorSet() {
            return this.colorSet;
        }

        public final Object[] getData() {
            return this.data;
        }

        public final boolean isDataSet() {
            return this.dataSet;
        }

        public static ParticleArgs get() {
            BUILDER.reset();
            return BUILDER;
        }

        public final ParticleArgs populateEmptyArgs(ParticleArgs container) {
            if (!container.isMotionSet()) {
                container.withMotion(this.getMotionX(), this.getMotionY(), this.getMotionZ());
            }
            if (!container.isColorSet()) {
                container.withColor(this.getColor());
            }
            if (!container.isScaleSet()) {
                container.withScale(this.getScale());
            }
            if (this.isDataSet()) {
                Object[] initialAdditionalArgs = container.getData();
                Object[] defaultArgs = this.getData();
                Object[] additionalArgs = container.getData();
                if (defaultArgs.length > initialAdditionalArgs.length) {
                    additionalArgs = new Object[defaultArgs.length];
                    container.withData(additionalArgs);
                }
                for (int i = 0; i < additionalArgs.length; ++i) {
                    if (i < initialAdditionalArgs.length) {
                        if (initialAdditionalArgs[i] == EMPTY_ARG) {
                            if (i >= defaultArgs.length) {
                                additionalArgs[i] = null;
                                continue;
                            }
                            additionalArgs[i] = defaultArgs[i];
                            continue;
                        }
                        additionalArgs[i] = initialAdditionalArgs[i];
                        continue;
                    }
                    if (i >= defaultArgs.length) continue;
                    additionalArgs[i] = defaultArgs[i];
                }
            }
            return container;
        }

        @Override
        public final void accept(ParticleArgs defaultArgs) {
            defaultArgs.populateEmptyArgs(this);
        }

        public static final class ArgumentDataBuilder<T extends ParticleArgs> {
            private int highestIndex = 0;
            private final Map<Integer, Object> setArgs = new HashMap<Integer, Object>();
            private final T args;

            private ArgumentDataBuilder(T args) {
                this.args = args;
            }

            public ArgumentDataBuilder<T> setData(int index, Object ... data) {
                if (index + data.length - 1 > this.highestIndex) {
                    this.highestIndex = index + data.length - 1;
                }
                for (int i = 0; i < data.length; ++i) {
                    this.setArgs.put(index + i, data[i]);
                }
                return this;
            }

            public ArgumentDataBuilder<T> setEmpty(int index) {
                return this.setData(index, EMPTY_ARG);
            }

            public T buildData() {
                Object[] data = new Object[this.highestIndex + 1];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = EMPTY_ARG;
                }
                for (Map.Entry<Integer, Object> entry : this.setArgs.entrySet()) {
                    data[entry.getKey().intValue()] = entry.getValue();
                }
                ((ParticleArgs)this.args).withData(data);
                return this.args;
            }

            /* synthetic */ ArgumentDataBuilder(ParticleArgs x0, 1 x1) {
                this(x0);
            }
        }
    }

    public static class ImmutableParticleArgs {
        public final World world;
        public final double x;
        public final double y;
        public final double z;
        public final double motionX;
        public final double motionY;
        public final double motionZ;
        public final float scale;
        public final int color;
        public final Object[] data;

        public ImmutableParticleArgs(World world, double x, double y, double z, ParticleArgs builder) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.motionX = builder.motionX;
            this.motionY = builder.motionY;
            this.motionZ = builder.motionZ;
            this.scale = builder.scale;
            this.color = builder.color;
            this.data = builder.data;
            builder.reset();
        }
    }
}

