/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.tools;

import com.bobmowzie.mowziesmobs.server.entity.LegSolverBiped;
import com.bobmowzie.mowziesmobs.server.entity.LegSolverQuadruped;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.util.math.MathHelper;

public final class LegArticulator {
    private LegArticulator() {
    }

    public static void articulateBiped(MowzieEntity entity, LegSolverBiped legs, AdvancedModelRenderer body, AdvancedModelRenderer leftThigh, AdvancedModelRenderer leftCalf, AdvancedModelRenderer rightThigh, AdvancedModelRenderer rightCalf, float rotThigh, float rotCalf, float delta) {
        float heightLeft = legs.left.getHeight(delta);
        float heightRight = legs.right.getHeight(delta);
        if (heightLeft > 0.0f || heightRight > 0.0f) {
            float sc = LegArticulator.getScale(entity);
            float avg = LegArticulator.avg(heightLeft, heightRight);
            body.field_78797_d += 16.0f / sc * avg;
            LegArticulator.articulateLegPair(sc, heightLeft, heightRight, avg, 0.0f, leftThigh, leftCalf, rightThigh, rightCalf, rotThigh, rotCalf);
        }
    }

    public static void articulateQuadruped(MowzieEntity entity, LegSolverQuadruped legs, AdvancedModelRenderer body, AdvancedModelRenderer neck, AdvancedModelRenderer backLeftThigh, AdvancedModelRenderer backLeftCalf, AdvancedModelRenderer backRightThigh, AdvancedModelRenderer backRightCalf, AdvancedModelRenderer frontLeftThigh, AdvancedModelRenderer frontLeftCalf, AdvancedModelRenderer frontRightThigh, AdvancedModelRenderer frontRightCalf, float rotBackThigh, float rotBackCalf, float rotFrontThigh, float rotFrontCalf, float delta) {
        float heightBackLeft = legs.backLeft.getHeight(delta);
        float heightBackRight = legs.backRight.getHeight(delta);
        float heightFrontLeft = legs.frontLeft.getHeight(delta);
        float heightFrontRight = legs.frontRight.getHeight(delta);
        if (heightBackLeft > 0.0f || heightBackRight > 0.0f || heightFrontLeft > 0.0f || heightFrontRight > 0.0f) {
            float sc = LegArticulator.getScale(entity);
            float backAvg = LegArticulator.avg(heightBackLeft, heightBackRight);
            float frontAvg = LegArticulator.avg(heightFrontLeft, heightFrontRight);
            float bodyLength = Math.abs(LegArticulator.avg(legs.backLeft.forward, legs.backRight.forward) - LegArticulator.avg(legs.frontLeft.forward, legs.frontRight.forward));
            float tilt = (float)(MathHelper.func_181159_b((double)bodyLength, (double)(backAvg - frontAvg)) - 1.5707963267948966);
            body.field_78797_d += 16.0f / sc * backAvg;
            body.field_78795_f += tilt;
            frontLeftThigh.field_78795_f -= tilt;
            frontRightThigh.field_78795_f -= tilt;
            neck.field_78795_f -= tilt;
            LegArticulator.articulateLegPair(sc, heightBackLeft, heightBackRight, backAvg, -backAvg, backLeftThigh, backLeftCalf, backRightThigh, backRightCalf, rotBackThigh, rotBackCalf);
            LegArticulator.articulateLegPair(sc, heightFrontLeft, heightFrontRight, frontAvg, -frontAvg, frontLeftThigh, frontLeftCalf, frontRightThigh, frontRightCalf, rotFrontThigh, rotFrontCalf);
        }
    }

    private static void articulateLegPair(float sc, float heightLeft, float heightRight, float avg, float offsetY, AdvancedModelRenderer leftThigh, AdvancedModelRenderer leftCalf, AdvancedModelRenderer rightThigh, AdvancedModelRenderer rightCalf, float rotThigh, float rotCalf) {
        float difLeft = Math.max(0.0f, heightRight - heightLeft);
        float difRight = Math.max(0.0f, heightLeft - heightRight);
        leftThigh.field_78797_d += 16.0f / sc * (Math.max(heightLeft, avg) + offsetY);
        rightThigh.field_78797_d += 16.0f / sc * (Math.max(heightRight, avg) + offsetY);
        leftThigh.field_78795_f -= rotThigh * difLeft;
        leftCalf.field_78795_f += rotCalf * difLeft;
        rightThigh.field_78795_f -= rotThigh * difRight;
        rightCalf.field_78795_f += rotCalf * difRight;
    }

    private static float avg(float a, float b) {
        return (a + b) / 2.0f;
    }

    private static float getScale(MowzieEntity entity) {
        return 1.0f;
    }
}

