/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

public class ChunkBitArray {
    private static final int CHUNK_SIZE = 65536;
    private static final int BITS_PER_WORD = 6;
    private final long[] words = new long[8192];

    public void set(int index) {
        int n = index >> 6;
        this.words[n] = this.words[n] | 1L << index;
    }

    public void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public void clear(int index) {
        int n = index >> 6;
        this.words[n] = this.words[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean get(int index) {
        return (this.words[index >> 6] & 1L << index) != 0L;
    }
}

