/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.registries.IRegistryDelegate;
import twilightforest.TwilightForestMod;

public class LootFunctionEnchant
extends LootFunction {
    private final Map<IRegistryDelegate<Enchantment>, Short> enchantments;

    protected LootFunctionEnchant(LootCondition[] conditions, Map<IRegistryDelegate<Enchantment>, Short> enchantments) {
        super(conditions);
        this.enchantments = enchantments;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        for (Map.Entry<IRegistryDelegate<Enchantment>, Short> e : this.enchantments.entrySet()) {
            if (stack.func_77973_b() == Items.field_151134_bR) {
                ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData((Enchantment)e.getKey().get(), (int)e.getValue().shortValue()));
                continue;
            }
            this.addEnchantment(stack, (Enchantment)e.getKey().get(), e.getValue());
        }
        return stack;
    }

    private void addEnchantment(ItemStack stack, Enchantment e, short level) {
        String enchantedCompoundKey;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        String string = enchantedCompoundKey = stack.func_77973_b() == Items.field_151134_bR ? "StoredEnchantments" : "ench";
        if (!stack.func_77978_p().func_150297_b(enchantedCompoundKey, 9)) {
            stack.func_77978_p().func_74782_a(enchantedCompoundKey, (NBTBase)new NBTTagList());
        }
        NBTTagList list = stack.func_77978_p().func_150295_c(enchantedCompoundKey, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound existing = list.func_150305_b(i);
            if (existing.func_74765_d("id") != Enchantment.func_185258_b((Enchantment)e)) continue;
            existing.func_74777_a("lvl", level);
            return;
        }
        NBTTagCompound newCmp = new NBTTagCompound();
        newCmp.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)e));
        newCmp.func_74777_a("lvl", level);
        list.func_74742_a((NBTBase)newCmp);
    }

    public static class Serializer
    extends LootFunction.Serializer<LootFunctionEnchant> {
        protected Serializer() {
            super(TwilightForestMod.prefix("enchant"), LootFunctionEnchant.class);
        }

        public void serialize(JsonObject object, LootFunctionEnchant function, JsonSerializationContext ctx) {
            if (!function.enchantments.isEmpty()) {
                JsonObject obj = new JsonObject();
                for (Map.Entry e : function.enchantments.entrySet()) {
                    obj.addProperty(((Enchantment)((IRegistryDelegate)e.getKey()).get()).getRegistryName().toString(), (Number)e.getValue());
                }
                object.add("enchantments", (JsonElement)obj);
            }
        }

        public LootFunctionEnchant deserialize(JsonObject object, JsonDeserializationContext ctx, LootCondition[] conditions) {
            HashMap<IRegistryDelegate<Enchantment>, Short> enchantments = new HashMap<IRegistryDelegate<Enchantment>, Short>();
            if (object.has("enchantments")) {
                JsonObject enchantObj = JsonUtils.func_152754_s((JsonObject)object, (String)"enchantments");
                for (Map.Entry e : enchantObj.entrySet()) {
                    Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation((String)e.getKey()));
                    if (ench == null) {
                        throw new JsonSyntaxException("Can't find enchantment " + (String)e.getKey());
                    }
                    short lvl = ((JsonElement)e.getValue()).getAsShort();
                    for (IRegistryDelegate other : enchantments.keySet()) {
                        if (ench.func_191560_c((Enchantment)other.get())) continue;
                        throw new JsonParseException(String.format("Enchantments %s and %s conflict", ench.getRegistryName(), ((Enchantment)other.get()).getRegistryName()));
                    }
                    enchantments.put((IRegistryDelegate<Enchantment>)ench.delegate, lvl);
                }
            }
            return new LootFunctionEnchant(conditions, enchantments);
        }
    }
}

