/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.TFFeature;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFBossSpawner;
import twilightforest.block.TFBlocks;
import twilightforest.entity.boss.EntityTFHydraHead;
import twilightforest.entity.boss.EntityTFHydraPart;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.enums.BossVariant;
import twilightforest.util.EntityUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.TFWorld;

public class EntityTFHydra
extends EntityLiving
implements IEntityMultiPart,
IMob {
    public static final ResourceLocation LOOT_TABLE = TwilightForestMod.prefix("entities/hydra");
    private static final int TICKS_BEFORE_HEALING = 1000;
    private static final int HEAD_RESPAWN_TICKS = 100;
    private static final int HEAD_MAX_DAMAGE = 120;
    private static final float ARMOR_MULTIPLIER = 8.0f;
    private static final int MAX_HEALTH = 360;
    private static float HEADS_ACTIVITY_FACTOR = 0.3f;
    private static final int SECONDARY_FLAME_CHANCE = 10;
    private static final int SECONDARY_MORTAR_CHANCE = 16;
    private static final DataParameter<Boolean> DATA_SPAWNHEADS = EntityDataManager.func_187226_a(EntityTFHydra.class, (DataSerializer)DataSerializers.field_187198_h);
    private final Entity[] partArray;
    public final int numHeads = 7;
    public final HydraHeadContainer[] hc = new HydraHeadContainer[7];
    public final MultiPartEntityPart body = new MultiPartEntityPart((IEntityMultiPart)this, "body", 4.0f, 4.0f);
    private final MultiPartEntityPart leftLeg = new MultiPartEntityPart((IEntityMultiPart)this, "leg", 2.0f, 3.0f);
    private final MultiPartEntityPart rightLeg = new MultiPartEntityPart((IEntityMultiPart)this, "leg", 2.0f, 3.0f);
    private final MultiPartEntityPart tail = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private int ticksSinceDamaged = 0;
    private int numTicksToChaseTarget;

    public EntityTFHydra(World world) {
        super(world);
        ArrayList<MultiPartEntityPart> parts = new ArrayList<MultiPartEntityPart>();
        parts.add(this.body);
        parts.add(this.leftLeg);
        parts.add(this.rightLeg);
        parts.add(this.tail);
        for (int i = 0; i < 7; ++i) {
            this.hc[i] = new HydraHeadContainer(this, i, i < 3);
            Collections.addAll(parts, this.hc[i].getNeckArray());
        }
        this.partArray = parts.toArray(new Entity[0]);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        this.field_70728_aV = 511;
        this.func_70105_a(16.0f, 12.0f);
        this.setSpawnHeads(true);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(360.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.field_70170_p.func_175656_a(this.func_180425_c().func_177982_a(0, 2, 0), TFBlocks.boss_spawner.func_176223_P().func_177226_a(BlockTFBossSpawner.VARIANT, (Comparable)((Object)BossVariant.HYDRA)));
            this.func_70106_y();
            for (HydraHeadContainer container : this.hc) {
                if (container.headEntity == null) continue;
                container.headEntity.func_70106_y();
            }
        } else {
            super.func_70623_bb();
        }
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        boolean flag;
        float f = MathHelper.func_76142_g((float)(p_110146_1_ - this.field_70761_aq));
        this.field_70761_aq += f * 0.3f;
        float f1 = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.field_70761_aq = this.field_70177_z - f1;
        if (f1 * f1 > 2500.0f) {
            this.field_70761_aq += f1 * 0.2f;
        }
        if (flag) {
            p_110146_2_ *= -1.0f;
        }
        return p_110146_2_;
    }

    public void func_70636_d() {
        int i;
        if ((this.hc[0].headEntity == null || this.hc[1].headEntity == null || this.hc[2].headEntity == null) && !this.field_70170_p.field_72995_K && this.shouldSpawnHeads()) {
            for (i = 0; i < 7; ++i) {
                this.hc[i].headEntity = new EntityTFHydraHead(this, "head" + i, 3.0f, 3.0f);
                this.hc[i].headEntity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.hc[i].setHeadPosition();
                this.field_70170_p.func_72838_d((Entity)this.hc[i].headEntity);
            }
            this.setSpawnHeads(false);
        }
        this.body.func_70071_h_();
        for (i = 0; i < 7; ++i) {
            this.hc[i].onUpdate();
        }
        if (this.field_70737_aN > 0) {
            for (i = 0; i < 7; ++i) {
                this.hc[i].setHurtTime(this.field_70737_aN);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.field_70170_p.field_72995_K && this.ticksSinceDamaged > 1000 && this.ticksSinceDamaged % 5 == 0) {
            this.func_70691_i(1.0f);
        }
        this.setDifficultyVariables();
        super.func_70636_d();
        this.body.field_70131_O = 6.0f;
        this.body.field_70130_N = 6.0f;
        this.tail.field_70130_N = 6.0f;
        this.tail.field_70131_O = 2.0f;
        float angle = (this.field_70761_aq + 180.0f) * 3.141593f / 180.0f;
        double dx = this.field_70165_t - (double)MathHelper.func_76126_a((float)angle) * 3.0;
        double dy = this.field_70163_u + 0.1;
        double dz = this.field_70161_v + (double)MathHelper.func_76134_b((float)angle) * 3.0;
        this.body.func_70107_b(dx, dy, dz);
        dx = this.field_70165_t - (double)MathHelper.func_76126_a((float)angle) * 10.5;
        dy = this.field_70163_u + 0.1;
        dz = this.field_70161_v + (double)MathHelper.func_76134_b((float)angle) * 10.5;
        this.tail.func_70107_b(dx, dy, dz);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70737_aN == 0) {
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.body.func_174813_aQ()), (Entity)this.body);
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.tail.func_174813_aQ()), (Entity)this.tail);
            }
            this.destroyBlocksInAABB(this.body.func_174813_aQ());
            this.destroyBlocksInAABB(this.tail.func_174813_aQ());
            for (int i2 = 0; i2 < 7; ++i2) {
                if (this.hc[i2].headEntity == null || !this.hc[i2].isActive()) continue;
                this.destroyBlocksInAABB(this.hc[i2].headEntity.func_174813_aQ());
            }
            if (this.field_70173_aa % 20 == 0 && this.isUnsteadySurfaceBeneath()) {
                this.destroyBlocksInAABB(this.func_174813_aQ().func_72317_d(0.0, -1.0, 0.0));
            }
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_SPAWNHEADS, (Object)false);
    }

    private boolean shouldSpawnHeads() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_SPAWNHEADS);
    }

    private void setSpawnHeads(boolean flag) {
        this.field_70180_af.func_187227_b(DATA_SPAWNHEADS, (Object)flag);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("SpawnHeads", this.shouldSpawnHeads());
        compound.func_74774_a("NumHeads", (byte)this.countActiveHeads());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSpawnHeads(compound.func_74767_n("SpawnHeads"));
        this.activateNumberOfHeads(compound.func_74771_c("NumHeads"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    protected void func_70619_bc() {
        int i;
        this.field_70702_br = 0.0f;
        this.field_191988_bg = 0.0f;
        float f = 48.0f;
        for (i = 0; i < 7; ++i) {
            if (!this.hc[i].isActive() || this.hc[i].getDamageTaken() <= 120) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.DYING);
            this.hc[i].endCurrentAction();
            this.hc[i].setRespawnCounter(100);
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].setRespawnCounter(100);
        }
        if (this.field_70146_Z.nextFloat() < 0.7f) {
            EntityPlayer entityplayer1 = this.field_70170_p.func_184142_a((Entity)this, (double)f, (double)f);
            if (entityplayer1 != null) {
                this.func_70624_b((EntityLivingBase)entityplayer1);
                this.numTicksToChaseTarget = 100 + this.field_70146_Z.nextInt(20);
            } else {
                this.field_70704_bt = (this.field_70146_Z.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, this.func_70646_bf());
            for (i = 0; i < 7; ++i) {
                if (this.hc[i].isAttacking() || this.hc[i].isSecondaryAttacking) continue;
                this.hc[i].setTargetEntity((Entity)this.func_70638_az());
            }
            if (this.func_70638_az().func_70089_S()) {
                float distance = this.func_70638_az().func_70032_d((Entity)this);
                if (this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                    this.attackEntity((Entity)this.func_70638_az(), distance);
                }
            }
            if (this.numTicksToChaseTarget-- <= 0 || this.func_70638_az().field_70128_L || this.func_70638_az().func_70068_e((Entity)this) > (double)(f * f)) {
                this.func_70624_b(null);
            }
        } else {
            if (this.field_70146_Z.nextFloat() < 0.05f) {
                this.field_70704_bt = (this.field_70146_Z.nextFloat() - 0.5f) * 20.0f;
            }
            this.field_70177_z += this.field_70704_bt;
            this.field_70125_A = 0.0f;
            for (i = 0; i < 7; ++i) {
                if (!this.hc[i].isIdle()) continue;
                this.hc[i].setTargetEntity(null);
            }
        }
        this.secondaryAttacks();
    }

    private void setDifficultyVariables() {
        HEADS_ACTIVITY_FACTOR = this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD ? 0.3f : 0.5f;
    }

    private int getRandomDeadHead() {
        for (int i = 0; i < 7; ++i) {
            if (!this.hc[i].canRespawn()) continue;
            return i;
        }
        return -1;
    }

    private void activateNumberOfHeads(int howMany) {
        int moreHeads = howMany - this.countActiveHeads();
        for (int i = 0; i < moreHeads; ++i) {
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].setNextState(HydraHeadContainer.State.IDLE);
            this.hc[otherHead].endCurrentAction();
        }
    }

    private void attackEntity(Entity target, float distance) {
        int i;
        int BITE_CHANCE = 10;
        int FLAME_CHANCE = 100;
        int MORTAR_CHANCE = 160;
        boolean targetAbove = target.func_174813_aQ().field_72338_b > this.func_174813_aQ().field_72337_e;
        for (i = 0; i < 3; ++i) {
            if (!this.hc[i].isIdle() || this.areTooManyHeadsAttacking(i)) continue;
            if (distance > 4.0f && distance < 10.0f && this.field_70146_Z.nextInt(BITE_CHANCE) == 0 && this.countActiveHeads() > 2 && !this.areOtherHeadsBiting(i)) {
                this.hc[i].setNextState(HydraHeadContainer.State.BITE_BEGINNING);
                continue;
            }
            if (distance > 0.0f && distance < 20.0f && this.field_70146_Z.nextInt(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.field_70146_Z.nextInt(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
        }
        for (i = 3; i < 7; ++i) {
            if (!this.hc[i].isIdle() || this.areTooManyHeadsAttacking(i)) continue;
            if (distance > 0.0f && distance < 20.0f && this.field_70146_Z.nextInt(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.field_70146_Z.nextInt(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
        }
    }

    private boolean areTooManyHeadsAttacking(int testHead) {
        int otherAttacks = 0;
        for (int i = 0; i < 7; ++i) {
            if (i == testHead || !this.hc[i].isAttacking()) continue;
            ++otherAttacks;
            if (!this.hc[i].isBiting()) continue;
            otherAttacks += 2;
        }
        return (float)otherAttacks >= 1.0f + (float)this.countActiveHeads() * HEADS_ACTIVITY_FACTOR;
    }

    private int countActiveHeads() {
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            if (!this.hc[i].isActive()) continue;
            ++count;
        }
        return count;
    }

    private boolean areOtherHeadsBiting(int testHead) {
        for (int i = 0; i < 7; ++i) {
            if (i == testHead || !this.hc[i].isBiting()) continue;
            return true;
        }
        return false;
    }

    private void secondaryAttacks() {
        for (int i = 0; i < 7; ++i) {
            if (this.hc[i].headEntity != null) continue;
            return;
        }
        EntityLivingBase secondaryTarget = this.findSecondaryTarget(20.0);
        if (secondaryTarget != null) {
            float distance = secondaryTarget.func_70032_d((Entity)this);
            for (int i = 1; i < 7; ++i) {
                if (!this.hc[i].isActive() || !this.hc[i].isIdle() || !this.isTargetOnThisSide(i, (Entity)secondaryTarget)) continue;
                if (distance > 0.0f && distance < 20.0f && this.field_70146_Z.nextInt(10) == 0) {
                    this.hc[i].setTargetEntity((Entity)secondaryTarget);
                    this.hc[i].isSecondaryAttacking = true;
                    this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                    continue;
                }
                if (!(distance > 8.0f) || !(distance < 32.0f) || this.field_70146_Z.nextInt(16) != 0) continue;
                this.hc[i].setTargetEntity((Entity)secondaryTarget);
                this.hc[i].isSecondaryAttacking = true;
                this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
            }
        }
    }

    private boolean isTargetOnThisSide(int headNum, Entity target) {
        double middleDist;
        double headDist = this.distanceSqXZ((Entity)this.hc[headNum].headEntity, target);
        return headDist < (middleDist = this.distanceSqXZ((Entity)this, target));
    }

    private double distanceSqXZ(Entity headEntity, Entity target) {
        double distX = headEntity.field_70165_t - target.field_70165_t;
        double distZ = headEntity.field_70161_v - target.field_70161_v;
        return distX * distX + distZ * distZ;
    }

    @Nullable
    private EntityLivingBase findSecondaryTarget(double range) {
        return this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(range, range, range)).stream().filter(e -> !(e instanceof EntityTFHydra) && !(e instanceof EntityTFHydraPart)).filter(e -> e != this.func_70638_az() && !this.isAnyHeadTargeting((Entity)e) && this.func_70635_at().func_75522_a((Entity)e)).min(Comparator.comparingDouble(arg_0 -> ((EntityTFHydra)this).func_70068_e(arg_0))).orElse(null);
    }

    private boolean isAnyHeadTargeting(Entity targetEntity) {
        for (int i = 0; i < 7; ++i) {
            if (this.hc[i].targetEntity == null || !this.hc[i].targetEntity.equals((Object)targetEntity)) continue;
            return true;
        }
        return false;
    }

    private void collideWithEntities(List<Entity> entities, Entity part) {
        double d0 = (part.func_174813_aQ().field_72340_a + part.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (part.func_174813_aQ().field_72339_c + part.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
        }
    }

    private boolean isUnsteadySurfaceBeneath() {
        int minX = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72340_a);
        int minZ = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72339_c);
        int maxX = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72336_d);
        int maxZ = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72334_f);
        int minY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int solid = 0;
        int total = 0;
        int dy = minY - 1;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                ++total;
                if (!this.field_70170_p.func_180495_p(new BlockPos(dx, dy, dz)).func_185904_a().func_76220_a()) continue;
                ++solid;
            }
        }
        return (float)solid / (float)total < 0.6f;
    }

    private void destroyBlocksInAABB(AxisAlignedBB box) {
        if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (BlockPos pos : WorldUtil.getAllInBB(box)) {
                if (!EntityUtil.canDestroyBlock(this.field_70170_p, pos, (Entity)this)) continue;
                this.field_70170_p.func_175655_b(pos, false);
            }
        }
    }

    public int func_70646_bf() {
        return 500;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return this.calculateRange(source) <= 400.0 && super.func_70097_a(source, (float)Math.round(damage / 8.0f));
    }

    public boolean attackEntityFromPart(EntityTFHydraPart part, DamageSource source, float damage) {
        boolean tookDamage;
        if (!this.field_70170_p.field_72995_K && source == DamageSource.field_76368_d) {
            this.destroyBlocksInAABB(part.func_174813_aQ());
        }
        HydraHeadContainer headCon = null;
        for (int i = 0; i < 7; ++i) {
            if (this.hc[i].headEntity != part) continue;
            headCon = this.hc[i];
        }
        double range = this.calculateRange(source);
        if (range > 400.0) {
            return false;
        }
        if (headCon != null && !headCon.isActive()) {
            return false;
        }
        if (headCon != null && (double)headCon.getCurrentMouthOpen() > 0.5) {
            tookDamage = super.func_70097_a(source, damage);
            headCon.addDamage(damage);
        } else {
            int armoredDamage = Math.round(damage / 8.0f);
            tookDamage = super.func_70097_a(source, (float)armoredDamage);
            if (headCon != null) {
                headCon.addDamage(armoredDamage);
            }
        }
        if (tookDamage) {
            this.ticksSinceDamaged = 0;
        }
        return tookDamage;
    }

    private double calculateRange(DamageSource damagesource) {
        return damagesource.func_76346_g() != null ? this.func_70068_e(damagesource.func_76346_g()) : -1.0;
    }

    public boolean func_70097_a(DamageSource src, float damage) {
        return src == DamageSource.field_76380_i && super.func_70097_a(src, damage);
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    public void func_70653_a(Entity entity, float strength, double xRatio, double zRatio) {
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.HYDRA_GROWL;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TFSounds.HYDRA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.HYDRA_DEATH;
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            TFWorld.markStructureConquered(this.field_70170_p, new BlockPos((Entity)this), TFFeature.HYDRA_LAIR);
        }
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70027_ad() {
        return false;
    }

    protected void func_70609_aI() {
        int headToDie;
        int i;
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 1) {
            for (i = 0; i < 7; ++i) {
                this.hc[i].setRespawnCounter(-1);
                if (!this.hc[i].isActive()) continue;
                this.hc[i].setNextState(HydraHeadContainer.State.IDLE);
                this.hc[i].endCurrentAction();
                this.hc[i].setHurtTime(200);
            }
        }
        if (this.field_70725_aQ <= 140 && this.field_70725_aQ % 20 == 0 && this.hc[headToDie = this.field_70725_aQ / 20 - 1].isActive()) {
            this.hc[headToDie].setNextState(HydraHeadContainer.State.DYING);
            this.hc[headToDie].endCurrentAction();
        }
        if (this.field_70725_aQ == 200) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
        }
        for (i = 0; i < 20; ++i) {
            double vx = this.field_70146_Z.nextGaussian() * 0.02;
            double vy = this.field_70146_Z.nextGaussian() * 0.02;
            double vz = this.field_70146_Z.nextGaussian() * 0.02;
            EnumParticleTypes particle = this.field_70146_Z.nextInt(2) == 0 ? EnumParticleTypes.EXPLOSION_LARGE : EnumParticleTypes.EXPLOSION_NORMAL;
            this.field_70170_p.func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.body.field_70130_N * 2.0f) - (double)this.body.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.body.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.body.field_70130_N * 2.0f) - (double)this.body.field_70130_N, vx, vy, vz, new int[0]);
        }
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_184222_aU() {
        return false;
    }
}

