/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.tcon.texture;

import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;
import twilightforest.TwilightForestMod;
import twilightforest.client.texture.GradientMappedTexture;
import twilightforest.client.texture.GradientNode;

public class GradientMappedTConTexture
extends AbstractColoredTexture {
    private final ResourceLocation textureIn;
    protected GradientNode[] gradientMap;
    protected boolean shouldStretchMinimumMaximum;
    protected float minimumValue;
    protected float maximumValue;

    GradientMappedTConTexture(ResourceLocation baseTextureLocation, String spriteName, boolean shouldStretchMinimumMaximum, GradientNode[] gradientMap) {
        super(baseTextureLocation, spriteName);
        this.shouldStretchMinimumMaximum = shouldStretchMinimumMaximum;
        this.gradientMap = gradientMap;
        this.textureIn = baseTextureLocation;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        TwilightForestMod.LOGGER.debug("Autogenerated {} from {}", (Object)this.func_94215_i(), (Object)this.textureIn);
        return super.load(manager, location, textureGetter);
    }

    protected void preProcess(int[] data) {
        if (this.shouldStretchMinimumMaximum) {
            int minimumValue = 255;
            int maximumValue = 0;
            for (int pixel : data) {
                if (RenderUtil.alpha((int)pixel) == 0) continue;
                minimumValue = Math.min(minimumValue, GradientMappedTConTexture.getPerceptualBrightness((int)pixel));
                maximumValue = Math.max(maximumValue, GradientMappedTConTexture.getPerceptualBrightness((int)pixel));
            }
            if (minimumValue > maximumValue) {
                this.minimumValue = (float)maximumValue / 255.0f;
                this.maximumValue = (float)minimumValue / 255.0f;
            } else {
                this.minimumValue = (float)minimumValue / 255.0f;
                this.maximumValue = (float)maximumValue / 255.0f;
            }
        } else {
            this.minimumValue = 0.0f;
            this.maximumValue = 1.0f;
        }
    }

    protected int colorPixel(int pixel, int pxCoord) {
        int a = RenderUtil.alpha((int)pixel);
        if (a == 0) {
            return pixel;
        }
        int rFrom = RenderUtil.red((int)pixel);
        int gFrom = RenderUtil.green((int)pixel);
        int bFrom = RenderUtil.blue((int)pixel);
        int rTo = 0;
        int gTo = 0;
        int bTo = 0;
        float gray = this.getModifiedValue((float)(rFrom + gFrom + bFrom) / 765.0f);
        if (gray <= this.gradientMap[0].node) {
            rTo = RenderUtil.red((int)this.gradientMap[0].color);
            gTo = RenderUtil.green((int)this.gradientMap[0].color);
            bTo = RenderUtil.blue((int)this.gradientMap[0].color);
        } else if (gray >= this.gradientMap[this.gradientMap.length - 1].node) {
            int i = this.gradientMap[this.gradientMap.length - 1].color;
            rTo = RenderUtil.red((int)i);
            gTo = RenderUtil.green((int)i);
            bTo = RenderUtil.blue((int)i);
        } else {
            for (int i = 0; i < this.gradientMap.length - 1; ++i) {
                if (gray == this.gradientMap[i].node) {
                    rTo = RenderUtil.red((int)this.gradientMap[i].color);
                    gTo = RenderUtil.green((int)this.gradientMap[i].color);
                    bTo = RenderUtil.blue((int)this.gradientMap[i].color);
                    continue;
                }
                if (!(gray >= this.gradientMap[i].node) || !(gray <= this.gradientMap[i + 1].node)) continue;
                return GradientMappedTexture.interpolateColors(GradientMappedTexture.normalize(gray, this.gradientMap[i].node, this.gradientMap[i + 1].node), this.gradientMap[i].color, this.gradientMap[i + 1].color, a);
            }
        }
        return RenderUtil.compose((int)rTo, (int)gTo, (int)bTo, (int)a);
    }

    protected final float getModifiedValue(float valueIn) {
        if (this.shouldStretchMinimumMaximum) {
            return (valueIn - this.minimumValue) / (this.maximumValue - this.minimumValue);
        }
        return valueIn;
    }
}

