/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.IRenderHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeFinalPlateau;
import twilightforest.biomes.TFBiomeFireSwamp;
import twilightforest.biomes.TFBiomeGlacier;
import twilightforest.biomes.TFBiomeHighlands;
import twilightforest.biomes.TFBiomeSnow;
import twilightforest.biomes.TFBiomeSwamp;
import twilightforest.biomes.TFBiomeThornlands;
import twilightforest.world.TFWorld;

public class TFWeatherRenderer
extends IRenderHandler {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation SPARKLES_TEXTURE = TwilightForestMod.getEnvTexture("sparkles.png");
    private final float[] rainxs = new float[1024];
    private final float[] rainys = new float[1024];
    private final Random random = new Random();
    private int rendererUpdateCount;
    private StructureBoundingBox protectedBox;

    public TFWeatherRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainxs[i << 5 | j] = -f1 / f2;
                this.rainys[i << 5 | j] = f / f2;
            }
        }
    }

    public void tick() {
        ++this.rendererUpdateCount;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.renderNormalWeather(partialTicks, mc);
        if (TFWorld.isProgressionEnforced((World)world) && !mc.field_71439_g.func_184812_l_() && !mc.field_71439_g.func_175149_v()) {
            this.renderLockedBiome(partialTicks, world, mc);
            this.renderLockedStructure(partialTicks, world, mc);
        }
    }

    private void renderNormalWeather(float partialTicks, Minecraft mc) {
        float f = mc.field_71441_e.func_72867_j(partialTicks);
        if (f > 0.0f) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            bufferbuilder.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainxs[i2] * 0.5;
                    double d4 = (double)this.rainys[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (!biome.func_76738_d() && !biome.func_76746_c()) continue;
                    int j2 = world.func_175725_q((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (world.func_72959_q().func_76939_a(f2, j2) >= 0.15f) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        double d5 = -((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                        double d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                        int k3 = j3 >> 16 & 0xFFFF;
                        int l3 = j3 & 0xFFFF;
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        mc.func_110434_K().func_110577_a(SNOW_TEXTURES);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = this.random.nextDouble() + (double)f1 * 0.01 * (double)((float)this.random.nextGaussian());
                    double d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }

    private void renderLockedBiome(float partialTicks, WorldClient wc, Minecraft mc) {
        if (this.isNearLockedBiome((World)wc, mc.func_175606_aa())) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            int x0 = MathHelper.func_76128_c((double)entity.field_70165_t);
            int y0 = MathHelper.func_76128_c((double)entity.field_70163_u);
            int z0 = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double dx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double dy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double dz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int y1 = MathHelper.func_76128_c((double)dy);
            int range = 5;
            if (mc.field_71474_y.field_74347_j) {
                range = 10;
            }
            Enum currentType = null;
            float combinedTicks = (float)this.rendererUpdateCount + partialTicks;
            bufferbuilder.func_178969_c(-dx, -dy, -dz);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int z = z0 - range; z <= z0 + range; ++z) {
                block8: for (int x = x0 - range; x <= x0 + range; ++x) {
                    int idx = (z - z0 + 16) * 32 + x - x0 + 16;
                    double rx = (double)this.rainxs[idx] * 0.5;
                    double ry = (double)this.rainys[idx] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(x, 0, z);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (TFWorld.isBiomeSafeFor(biome, entity)) continue;
                    int groundY = 0;
                    int minY = y0 - range;
                    int maxY = y0 + range;
                    if (minY < groundY) {
                        minY = groundY;
                    }
                    if (maxY < groundY) {
                        maxY = groundY;
                    }
                    int y = groundY;
                    if (groundY < y1) {
                        y = y1;
                    }
                    if (minY == maxY) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                    RenderType nextType = this.getRenderType(biome);
                    if (nextType == null) continue;
                    if (currentType != nextType) {
                        if (currentType != null) {
                            tessellator.func_78381_a();
                        }
                        currentType = nextType;
                        mc.func_110434_K().func_110577_a(nextType.getTextureLocation());
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    switch (1.$SwitchMap$twilightforest$client$renderer$TFWeatherRenderer$RenderType[currentType.ordinal()]) {
                        case 1: {
                            double d5 = -((double)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                            double d6 = (double)((float)x + 0.5f) - entity.field_70165_t;
                            double d7 = (double)((float)z + 0.5f) - entity.field_70161_v;
                            float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)range;
                            float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * 1.0f;
                            blockpos$mutableblockpos.func_181079_c(x, y, z);
                            int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                            int k3 = j3 >> 16 & 0xFFFF;
                            int l3 = j3 & 0xFFFF;
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)maxY, (double)z - ry + 0.5).func_187315_a(0.0, (double)minY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)maxY, (double)z + ry + 0.5).func_187315_a(1.0, (double)minY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)minY, (double)z + ry + 0.5).func_187315_a(1.0, (double)maxY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)minY, (double)z - ry + 0.5).func_187315_a(0.0, (double)maxY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                            continue block8;
                        }
                        case 2: {
                            double d8 = 0.0;
                            double d9 = this.random.nextDouble() + (double)combinedTicks * 0.01 * (double)((float)this.random.nextGaussian());
                            double d10 = this.random.nextDouble() + (double)(combinedTicks * (float)this.random.nextGaussian()) * 0.001;
                            double d11 = (double)((float)x + 0.5f) - entity.field_70165_t;
                            double d12 = (double)((float)z + 0.5f) - entity.field_70161_v;
                            float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)range;
                            float r = this.random.nextFloat() * 0.3f;
                            float g = this.random.nextFloat() * 0.3f;
                            float b = this.random.nextFloat() * 0.3f;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * 1.0f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)maxY, (double)z - ry + 0.5).func_187315_a(0.0 + d9, (double)minY * 0.25 + d8 + d10).func_181666_a(r, g, b, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)maxY, (double)z + ry + 0.5).func_187315_a(1.0 + d9, (double)minY * 0.25 + d8 + d10).func_181666_a(r, g, b, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)minY, (double)z + ry + 0.5).func_187315_a(1.0 + d9, (double)maxY * 0.25 + d8 + d10).func_181666_a(r, g, b, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)minY, (double)z - ry + 0.5).func_187315_a(0.0 + d9, (double)maxY * 0.25 + d8 + d10).func_181666_a(r, g, b, f5).func_187314_a(j4, k4).func_181675_d();
                            continue block8;
                        }
                        case 3: {
                            double d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            double d9 = this.random.nextDouble() + (double)combinedTicks * 0.01 * (double)((float)this.random.nextGaussian());
                            double d10 = this.random.nextDouble() + (double)(combinedTicks * (float)this.random.nextGaussian()) * 0.001;
                            double d11 = (double)((float)x + 0.5f) - entity.field_70165_t;
                            double d12 = (double)((float)z + 0.5f) - entity.field_70161_v;
                            float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)range;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * 1.0f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            float color = this.random.nextFloat() * 0.2f + 0.8f;
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)maxY, (double)z - ry + 0.5).func_187315_a(0.0 + d9, (double)minY * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)maxY, (double)z + ry + 0.5).func_187315_a(1.0 + d9, (double)minY * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)minY, (double)z + ry + 0.5).func_187315_a(1.0 + d9, (double)maxY * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)minY, (double)z - ry + 0.5).func_187315_a(0.0 + d9, (double)maxY * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                            continue block8;
                        }
                        case 4: {
                            double d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            double d9 = 0.0;
                            double d10 = this.random.nextDouble() + (double)(combinedTicks * (float)this.random.nextGaussian()) * 0.001;
                            double d11 = (double)((float)x + 0.5f) - entity.field_70165_t;
                            double d12 = (double)((float)z + 0.5f) - entity.field_70161_v;
                            float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)range;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * this.random.nextFloat();
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)maxY, (double)z - ry + 0.5).func_187315_a(0.0 + d9, (double)minY * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)maxY, (double)z + ry + 0.5).func_187315_a(1.0 + d9, (double)minY * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)minY, (double)z + ry + 0.5).func_187315_a(1.0 + d9, (double)maxY * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)minY, (double)z - ry + 0.5).func_187315_a(0.0 + d9, (double)maxY * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                            continue block8;
                        }
                        case 5: {
                            double d5 = -((double)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                            double d6 = (double)((float)x + 0.5f) - entity.field_70165_t;
                            double d7 = (double)((float)z + 0.5f) - entity.field_70161_v;
                            float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)range;
                            float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * 1.0f;
                            blockpos$mutableblockpos.func_181079_c(x, y, z);
                            int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                            int k3 = j3 >> 16 & 0xFFFF;
                            int l3 = j3 & 0xFFFF;
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)maxY, (double)z - ry + 0.5).func_187315_a(0.0, (double)minY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)maxY, (double)z + ry + 0.5).func_187315_a(1.0, (double)minY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                            bufferbuilder.func_181662_b((double)x + rx + 0.5, (double)minY, (double)z + ry + 0.5).func_187315_a(1.0, (double)maxY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                            bufferbuilder.func_181662_b((double)x - rx + 0.5, (double)minY, (double)z - ry + 0.5).func_187315_a(0.0, (double)maxY * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        }
                    }
                }
            }
            if (currentType != null) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }

    private void renderLockedStructure(float partialTicks, WorldClient wc, Minecraft mc) {
        if (this.isNearLockedStructure((World)wc, mc.func_175606_aa())) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            bufferbuilder.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainxs[i2] * 0.5;
                    double d4 = (double)this.rainys[i2] * 0.5;
                    if (this.protectedBox == null || !this.protectedBox.func_78885_a(l1, k1, l1, k1)) continue;
                    int structureMin = this.protectedBox.field_78895_b - 4;
                    int structureMax = this.protectedBox.field_78894_e + 4;
                    int k2 = j - i1;
                    int l2 = j + i1 * 2;
                    if (k2 < structureMin) {
                        k2 = structureMin;
                    }
                    if (l2 < structureMin) {
                        l2 = structureMin;
                    }
                    if (k2 > structureMax) {
                        k2 = structureMax;
                    }
                    if (l2 > structureMax) {
                        l2 = structureMax;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    if (j1 != 0) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 0;
                        mc.func_110434_K().func_110577_a(SPARKLES_TEXTURE);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d5 = -((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                    double d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                    float f = this.random.nextFloat();
                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                    int j3 = 0xF000F0;
                    int k3 = j3 >> 16 & 0xFFFF;
                    int l3 = j3 & 0xFFFF;
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }

    private boolean isNearLockedBiome(World world, Entity viewEntity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int range = 15;
        int px = MathHelper.func_76128_c((double)viewEntity.field_70165_t);
        int pz = MathHelper.func_76128_c((double)viewEntity.field_70161_v);
        for (int z = pz - 15; z <= pz + 15; ++z) {
            for (int x = px - 15; x <= px + 15; ++x) {
                Biome biome = world.func_180494_b((BlockPos)pos.func_181079_c(x, 0, z));
                if (TFWorld.isBiomeSafeFor(biome, viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNearLockedStructure(World world, Entity viewEntity) {
        int range = 15;
        int px = MathHelper.func_76128_c((double)viewEntity.field_70165_t);
        int pz = MathHelper.func_76128_c((double)viewEntity.field_70161_v);
        return this.protectedBox != null && this.protectedBox.func_78885_a(px - 15, pz - 15, px + 15, pz + 15);
    }

    public void setProtectedBox(StructureBoundingBox protectedBox) {
        this.protectedBox = protectedBox;
    }

    private RenderType getRenderType(Biome biome) {
        if (biome instanceof TFBiomeSnow || biome instanceof TFBiomeGlacier) {
            return RenderType.BLIZZARD;
        }
        if (biome instanceof TFBiomeSwamp) {
            return RenderType.MOSQUITO;
        }
        if (biome instanceof TFBiomeFireSwamp) {
            return RenderType.ASHES;
        }
        if (biome instanceof TFBiomeDarkForest) {
            return this.random.nextInt(2) == 0 ? RenderType.DARK_STREAM : null;
        }
        if (biome instanceof TFBiomeHighlands || biome instanceof TFBiomeThornlands || biome instanceof TFBiomeFinalPlateau) {
            return RenderType.BIG_RAIN;
        }
        return null;
    }

    private static enum RenderType {
        BLIZZARD("blizzard.png"),
        MOSQUITO("mosquitoes.png"),
        ASHES("ashes.png"),
        DARK_STREAM("darkstream.png"),
        BIG_RAIN("bigrain.png");

        private final ResourceLocation textureLocation;

        private RenderType(String textureName) {
            this.textureLocation = TwilightForestMod.getEnvTexture(textureName);
        }

        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }
    }
}

