/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.PlacedBlockTriggerInstanceExtended;
import com.bloodnbonesgaming.triumph.config.data.LocationData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/placed_block", classExplaination="These are the functions which can be called on a minecraft:placed_block trigger.")
public class PlayerPlacedBlockTriggerData
extends CriterionTriggerData {
    ItemPredicate itemPredicate = ItemPredicate.field_192495_a;
    BlockPredicate blockPredicate = BlockPredicate.ANY;
    private final ItemBlockData blockData = new ItemBlockData();
    private final LocationData locationData = new LocationData();
    private final ItemBlockData itemData = new ItemBlockData();

    public PlayerPlacedBlockTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        BlockPredicate block = this.blockPredicate == BlockPredicate.ANY ? this.blockData.buildBlockPredicate() : this.blockPredicate;
        ItemPredicate item = this.itemPredicate == ItemPredicate.field_192495_a ? this.itemData.buildItemPredicate() : this.itemPredicate;
        return new Criterion((ICriterionInstance)new PlacedBlockTriggerInstanceExtended(block, this.locationData.buildLocationPredicate(), item));
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the required item.")
    public void setItem(ItemBlockData data) throws Exception {
        this.itemPredicate = data.buildItemPredicate();
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block data", notes="Sets the required block.")
    public void setBlock(ItemBlockData data) throws Exception {
        this.blockPredicate = data.buildBlockPredicate();
    }

    public ItemBlockData getBlock() {
        return this.blockData;
    }

    public void setBlock(String blockName) {
        this.setBlock(blockName, null);
    }

    public void setBlock(String blockName, Integer meta) {
        this.blockData.setLocation(blockName);
        this.blockData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public void setBlockOreDict(String oreDict) throws Exception {
        this.blockData.setOre(oreDict);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object so functions can be called on it.")
    public LocationData getLocationData() {
        return this.locationData;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id. Can be an int or String.")
    public void setBiome(int id) {
        this.locationData.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id. Used for things like structures.")
    public void setFeature(String feature) {
        this.locationData.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="int", usage="dimension id", notes="Sets the dimension id.")
    public void setDimID(int dimID) {
        this.locationData.setDimID(dimID);
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType id", notes="Sets the WorldType id.")
    public void setWorldType(String worldType) {
        this.locationData.setWorldType(worldType);
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the generator options string.")
    public void setGeneratorOptions(String generatorOptions) {
        this.locationData.setGeneratorOptions(generatorOptions);
    }

    public ItemBlockData getItemData() {
        return this.itemData;
    }

    public void setItem(String itemName) {
        this.setItem(itemName, null);
    }

    public void setItem(String itemName, Integer meta) {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public void setItemOreDict(String oreDict) throws Exception {
        this.itemData.setOre(oreDict);
    }
}

