/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.DistanceData;
import com.bloodnbonesgaming.triumph.config.data.LocationData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NetherTravelTrigger;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/nether_travel", classExplaination="These are the functions which can be called on a minecraft:nether_travel criteria trigger.")
public class NetherTravelTriggerData
extends CriterionTriggerData {
    private final LocationData entered = new LocationData();
    private final LocationData exited = new LocationData();
    private final DistanceData distance = new DistanceData();

    public NetherTravelTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() {
        return new Criterion((ICriterionInstance)new NetherTravelTrigger.Instance((LocationPredicate)this.entered.buildLocationPredicate(), (LocationPredicate)this.exited.buildLocationPredicate(), this.distance.buildDistancePredicate()));
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object for the entered location so functions can be called on it.")
    public LocationData getEnteredData() {
        return this.entered;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id for the entered location. Can be an int or String.")
    public void setEnteredBiome(int id) {
        this.entered.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id for the entered location. Used for things like structures.")
    public void setEnteredFeature(String feature) {
        this.entered.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="int", usage="dimension id", notes="Sets the dimension id.")
    public void setEnteredDimID(int dimID) {
        this.entered.setDimID(dimID);
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType id", notes="Sets the WorldType id.")
    public void setEnteredWorldType(String worldType) {
        this.entered.setWorldType(worldType);
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the generator options string.")
    public void setEnteredGeneratorOptions(String generatorOptions) {
        this.entered.setGeneratorOptions(generatorOptions);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object for the exited location so functions can be called on it.")
    public LocationData getExitedData() {
        return this.exited;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id for the exited location. Can be an int or String.")
    public void setExitedBiome(int id) {
        this.exited.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id for the exited location. Used for things like structures.")
    public void setExitedFeature(String feature) {
        this.exited.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="int", usage="dimension id", notes="Sets the dimension id.")
    public void setExitedDimID(int dimID) {
        this.exited.setDimID(dimID);
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType id", notes="Sets the WorldType id.")
    public void setExitedWorldType(String worldType) {
        this.exited.setWorldType(worldType);
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the generator options string.")
    public void setExitedGeneratorOptions(String generatorOptions) {
        this.exited.setGeneratorOptions(generatorOptions);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the DistanceData object so functions can be called on it.")
    public DistanceData getDistanceData() {
        return this.distance;
    }
}

