/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.CountHandler;
import com.bloodnbonesgaming.triumph.advancements.criterion.PlayerDataHandler;
import com.bloodnbonesgaming.triumph.config.data.PlayerData;
import net.minecraft.advancements.Criterion;

public abstract class CriterionTriggerData {
    protected final String criterionName;
    protected final String advancementName;
    private PlayerData player = new PlayerData();

    public CriterionTriggerData(String criterionName, String advancementName) {
        this.criterionName = criterionName;
        this.advancementName = advancementName;
    }

    @ScriptMethodDocumentation(args="int", usage="count", notes="Sets the number of times this criteria must be completed before it counts towards advancement progress.")
    public void setCount(int count) {
        CountHandler.addRequiredCount(this.advancementName, this.criterionName, count);
    }

    @ScriptMethodDocumentation(usage="", notes="Gets the PlayerData for the criteria. Can set many things to test against the player themselves.")
    public PlayerData getPlayerData() {
        return this.player;
    }

    public void buildPlayerPredicate() throws Exception {
        PlayerDataHandler.addPlayerPredicate(this.advancementName, this.criterionName, this.player.buildPredicate());
    }

    public abstract Criterion buildCriterion() throws Exception;
}

