/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPMushroom;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import dynamictreesbop.ModContent;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesOakConifer
extends SpeciesRare {
    public SpeciesOakConifer(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "oakconifer"), treeFamily, ModContent.leaves.get("oakconifer"));
        this.setBasicGrowingParameters(0.3f, 16.0f, 3, 3, 0.9f);
        this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"conifer"));
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.PLAINS, 1.05f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
        this.setupStandardSeedDropping();
        this.leavesProperties.setTree(treeFamily);
    }

    public boolean isBiomePerfect(Biome biome) {
        return biome == BOPBiomes.temperate_rainforest.orNull();
    }

    public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        BlockPos highest = Collections.max(endPoints, (a, b) -> a.func_177956_o() - b.func_177956_o());
        world.func_175656_a(highest.func_177981_b(1), this.leavesProperties.getDynamicLeavesState(4));
        world.func_175656_a(highest.func_177981_b(2), this.leavesProperties.getDynamicLeavesState(3));
        world.func_175656_a(highest.func_177981_b(3), this.leavesProperties.getDynamicLeavesState(1));
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public int maxBranchRadius() {
        return 8;
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.PORTOBELLO));
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }
}

