/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorInvoluntarySeed;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesJungleTwiglet
extends SpeciesRare {
    public SpeciesJungleTwiglet(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "jungletwiglet"), treeFamily, ModContent.leaves.get("jungletwiglet"));
        this.setBasicGrowingParameters(0.3f, 2.5f, 1, 2, 1.0f);
        this.envFactor(BiomeDictionary.Type.SNOWY, 0.25f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 1.05f);
        this.addAcceptableSoil(new Block[]{Blocks.field_150349_c, BOPBlocks.grass, BOPBlocks.dirt, Blocks.field_150354_m});
        this.addDropCreator((IDropCreator)new DropCreatorInvoluntarySeed());
        this.remDropCreator(new ResourceLocation("dynamictrees", "logs"));
        this.leavesProperties.setTree(treeFamily);
    }

    public Species.LogsAndSticks getLogsAndSticks(float volume) {
        return super.getLogsAndSticks(volume * 16.0f);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesJungleTwiglet.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.overgrown_cliffs.orNull(), (Biome)BOPBiomes.tropical_island.orNull(), (Biome)BOPBiomes.brushland.orNull(), (Biome)BOPBiomes.oasis.orNull()});
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public boolean placeRootyDirtBlock(World world, BlockPos rootPos, int life) {
        if (world.func_180495_p(rootPos).func_185904_a() == Material.field_151595_p) {
            world.func_175656_a(rootPos, ModBlocks.blockRootySand.func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(life)));
        } else {
            world.func_175656_a(rootPos, this.getRootyBlock().func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(life)));
        }
        return true;
    }
}

