/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPLeaves;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesFloweringOak
extends SpeciesRare {
    public SpeciesFloweringOak(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "floweringoak"), treeFamily, ModContent.floweringOakLeavesProperties);
        this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.85f);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.generateSeed();
        this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
        this.addDropCreator((IDropCreator)new DropCreatorFruit(BOPItems.peach));
        this.setupStandardSeedDropping();
        ModContent.floweringOakLeavesProperties.setTree(treeFamily);
        treeFamily.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.FLOWERING);
    }

    public boolean isBiomePerfect(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
    }

    public int maxBranchRadius() {
        return 8;
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }

    public int saplingColorMultiplier(IBlockState state, IBlockAccess access, BlockPos pos, int tintIndex) {
        return tintIndex != 0 ? 0xFFFFFF : this.getLeavesProperties().foliageColorMultiplier(state, access, pos);
    }
}

