/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesAcaciaBrush
extends SpeciesRare {
    public SpeciesAcaciaBrush(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "acaciabrush"), treeFamily, ModContent.leaves.get("acaciabrush"));
        this.setBasicGrowingParameters(0.25f, 6.0f, 3, 4, 0.7f);
        this.setSoilLongevity(1);
        this.envFactor(BiomeDictionary.Type.WET, 0.5f);
        this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
        this.envFactor(BiomeDictionary.Type.SAVANNA, 1.05f);
        this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
        this.setupStandardSeedDropping();
        this.leavesProperties.setTree(treeFamily);
    }

    public Species.LogsAndSticks getLogsAndSticks(float volume) {
        return super.getLogsAndSticks(volume * 4.0f);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesAcaciaBrush.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.brushland.orNull()});
    }

    public int getReinfTravel() {
        return 0;
    }

    protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
        if (signal.isInTrunk() && newDir != EnumFacing.UP) {
            signal.energy *= 0.5f;
        }
        return newDir;
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }
}

