/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenBush;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreePine
extends TreeFamily {
    public TreePine() {
        super(new ResourceLocation("dynamictreesbop", "pine"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.PINE);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.PINE));
        ModContent.leaves.get("pine").setTree((TreeFamily)this);
        this.hasConiferVariants = true;
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.PINE);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPine(this));
    }

    public class SpeciesPine
    extends Species {
        SpeciesPine(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("pine"));
            this.setBasicGrowingParameters(0.3f, 16.0f, 4, 4, 0.9f);
            this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic(6.0f).setHorizontalLimiter(1.8f).setHeightVariation(6));
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
            this.addGenFeature((IGenFeature)new FeatureGenBush().setBiomePredicate(b -> b == BOPBiomes.shield.orNull()), 4);
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS);
        }
    }
}

