/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenCocoa;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeMahogany
extends TreeFamily {
    public TreeMahogany() {
        super(new ResourceLocation("dynamictreesbop", "mahogany"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.MAHOGANY);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.MAHOGANY));
        ModContent.leaves.get("mahogany").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.MAHOGANY);
        this.canSupportCocoa = true;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMahogany(this));
    }

    public boolean onTreeActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockBranch branch;
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 3 && (branch = TreeHelper.getBranch((IBlockState)state)) != null && branch.getRadius(state) == 8) {
            if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
                pos = pos.func_177972_a(side);
            }
            if (world.func_175623_d(pos)) {
                IBlockState cocoaState = ModBlocks.blockFruitCocoa.func_180642_a(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player);
                EnumFacing facing = (EnumFacing)cocoaState.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                world.func_180501_a(pos, ModBlocks.blockFruitCocoa.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 2);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                return true;
            }
        }
        return super.onTreeActivated(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public class SpeciesMahogany
    extends Species {
        public SpeciesMahogany(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("mahogany"));
            this.setBasicGrowingParameters(0.15f, 16.0f, 2, 7, 10.9f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.15f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.2f);
            this.envFactor(BiomeDictionary.Type.HOT, 1.1f);
            this.envFactor(BiomeDictionary.Type.WET, 1.1f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenCocoa());
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesMahogany.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.tropical_rainforest.orNull(), (Biome)BOPBiomes.overgrown_cliffs.orNull()});
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            if ((double)signal.energy < 3.5 && signal.energy > 1.0f) {
                probMap[1] = 1;
                probMap[5] = 0;
                probMap[4] = 0;
                probMap[3] = 0;
                probMap[2] = 0;
            } else {
                float r = Math.max(Math.abs(signal.delta.func_177958_n()), Math.abs(signal.delta.func_177952_p()));
                probMap[5] = 3;
                probMap[4] = 3;
                probMap[3] = 3;
                probMap[2] = 3;
                probMap[1] = 1 + (int)((double)r * 2.5);
                if (signal.delta.func_177952_p() > 0) {
                    probMap[2] = 0;
                }
                if (signal.delta.func_177952_p() < 0) {
                    probMap[3] = 0;
                }
                if (signal.delta.func_177958_n() > 0) {
                    probMap[4] = 0;
                }
                if (signal.delta.func_177958_n() < 0) {
                    probMap[5] = 0;
                }
                probMap[originDir.ordinal()] = 0;
                int n = signal.dir.ordinal();
                probMap[n] = probMap[n] + (signal.dir == EnumFacing.UP ? (int)(((double)r - 1.75) * 1.5) : 0);
            }
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (newDir != EnumFacing.UP) {
                signal.energy += 0.75f;
            }
            if (newDir == EnumFacing.UP && signal.dir != EnumFacing.UP) {
                signal.energy += ((float)Math.max(Math.abs(signal.delta.func_177958_n()), Math.abs(signal.delta.func_177952_p())) - 2.0f) * 1.5f;
            }
            return newDir;
        }
    }
}

