/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeFir
extends TreeFamily {
    Species smallSpecies;

    public TreeFir() {
        super(new ResourceLocation("dynamictreesbop", "fir"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.FIR);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.FIR));
        this.hasConiferVariants = true;
        ModContent.leaves.get("fir").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.FIR);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMegaFir(this));
        this.smallSpecies = new SpeciesFir(this);
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.smallSpecies);
    }

    public boolean isThick() {
        return true;
    }

    public class SpeciesFir
    extends Species {
        SpeciesFir(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), treeFamily.getName().func_110623_a() + "small"), treeFamily, ModContent.leaves.get("fir"));
            this.setBasicGrowingParameters(0.3f, 16.0f, 3, 3, 0.9f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"conifer"));
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS);
        }

        public int maxBranchRadius() {
            return 8;
        }

        public ItemStack getSeedStack(int qty) {
            return TreeFir.this.getCommonSpecies().getSeedStack(qty);
        }

        public Seed getSeed() {
            return TreeFir.this.getCommonSpecies().getSeed();
        }
    }

    public class SpeciesMegaFir
    extends Species {
        SpeciesMegaFir(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("fir"));
            this.setBasicGrowingParameters(0.3f, 32.0f, 7, 7, 1.0f);
            this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic(4.5f).setHeightVariation(8));
            this.setSoilLongevity(14);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
            this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
            this.addGenFeature((IGenFeature)new FeatureGenMound(999));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS);
        }

        public boolean isThick() {
            return true;
        }
    }
}

