/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeDead
extends TreeFamily {
    Species decayedSpecies;

    public TreeDead() {
        super(new ResourceLocation("dynamictreesbop", "dead"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.DEAD);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.DEAD));
        ModContent.leaves.get("dead").setTree((TreeFamily)this);
        ModContent.decayedLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.DEAD);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesDead(this));
        this.decayedSpecies = new SpeciesDecayed(this);
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.decayedSpecies);
    }

    public class SpeciesDecayed
    extends Species {
        SpeciesDecayed(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), "decayed"), treeFamily, ModContent.decayedLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 1.0f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt, BOPBlocks.dried_sand, Blocks.field_150354_m, Blocks.field_150405_ch, Blocks.field_150406_ce});
        }

        public boolean grow(World world, BlockRooty rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean natural) {
            return true;
        }

        public boolean canGrowWithBoneMeal(World world, BlockPos pos) {
            return false;
        }

        public boolean canUseBoneMealNow(World world, Random rand, BlockPos pos) {
            return false;
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            return false;
        }
    }

    public class SpeciesDead
    extends Species {
        SpeciesDead(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("dead"));
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.5f);
            this.envFactor(BiomeDictionary.Type.LUSH, 0.75f);
            this.envFactor(BiomeDictionary.Type.SPOOKY, 1.05f);
            this.envFactor(BiomeDictionary.Type.DEAD, 1.05f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt, BOPBlocks.dried_sand, Blocks.field_150354_m});
            this.addDropCreator((IDropCreator)new DropCreatorFruit(BOPItems.persimmon));
        }

        public boolean grow(World world, BlockRooty rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean natural) {
            return true;
        }

        public boolean canGrowWithBoneMeal(World world, BlockPos pos) {
            return false;
        }

        public boolean canUseBoneMealNow(World world, Random rand, BlockPos pos) {
            return false;
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            return false;
        }
    }
}

