/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.block.BlockBOPMushroom;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeCherry
extends TreeFamily {
    Species whiteSpecies;

    public TreeCherry() {
        super(new ResourceLocation("dynamictreesbop", "cherry"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.CHERRY);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.CHERRY));
        ModContent.leaves.get("pinkcherry").setTree((TreeFamily)this);
        ModContent.leaves.get("whitecherry").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> {
            if (state.func_177230_c() instanceof BlockBOPLeaves) {
                BOPTrees treeType = (BOPTrees)state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty);
                return treeType == BOPTrees.PINK_CHERRY || treeType == BOPTrees.WHITE_CHERRY;
            }
            return false;
        });
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPinkCherry(this));
        this.whiteSpecies = new SpeciesWhiteCherry(this);
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.whiteSpecies);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        itemList.add((Item)this.whiteSpecies.getSeed());
        return super.getRegisterableItems(itemList);
    }

    public class SpeciesWhiteCherry
    extends SpeciesRare {
        SpeciesWhiteCherry(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), "whitecherry"), treeFamily, ModContent.leaves.get("whitecherry"));
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesWhiteCherry.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.cherry_blossom_grove.orNull()});
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.TOADSTOOL) : BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.PORTOBELLO));
                    world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
                }
                return true;
            }
            return false;
        }
    }

    public class SpeciesPinkCherry
    extends Species {
        SpeciesPinkCherry(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), "pinkcherry"), treeFamily, ModContent.leaves.get("pinkcherry"));
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesPinkCherry.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.cherry_blossom_grove.orNull()});
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.TOADSTOOL) : BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.PORTOBELLO));
                    world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
                }
                return true;
            }
            return false;
        }
    }
}

