/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.proxy;

import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.common.block.BlockBOPLeaves;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import dynamictreesbop.ModContent;
import dynamictreesbop.items.ItemMagicSeed;
import dynamictreesbop.items.ItemMapleSeed;
import dynamictreesbop.models.ModelLoaderBlockBranchBamboo;
import dynamictreesbop.models.ModelLoaderBlockPalmFronds;
import dynamictreesbop.proxy.CommonProxy;
import dynamictreesbop.renderers.RenderMagicSeed;
import dynamictreesbop.renderers.RenderMapleSeed;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        this.registerClientEventHandlers();
        this.registerEntityRenderers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockBranchBamboo());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockPalmFronds());
    }

    @Override
    public void init() {
        super.init();
        this.registerColorHandlers();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    public void registerColorHandlers() {
        int magenta = 0xFF00FF;
        ModelHelper.regColorHandler((Block)ModContent.floweringOakLeaves, (IBlockColor)new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                boolean inWorld = worldIn != null && pos != null;
                Block block = state.func_177230_c();
                if (inWorld && tintIndex == 0 && TreeHelper.isLeaves((Block)block)) {
                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                }
                return 0xFFFFFF;
            }
        });
        ModelHelper.regColorHandler((Block)ModContent.palmFrondLeaves, (IBlockColor)new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                boolean inWorld = worldIn != null && pos != null;
                Block block = state.func_177230_c();
                if (inWorld && tintIndex == 0 && TreeHelper.isLeaves((Block)block)) {
                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                }
                return 0xFFFFFF;
            }
        });
        for (final BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId((String)"dynamictreesbop").values()) {
            ModelHelper.regColorHandler((Block)leaves, (IBlockColor)new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    boolean inWorld = worldIn != null && pos != null;
                    IBlockState primLeaves = leaves.getProperties(state).getPrimitiveLeaves();
                    Block block = state.func_177230_c();
                    if (primLeaves.func_177230_c() instanceof BlockBOPLeaves) {
                        switch (BlockBOPLeaves.getColoringType((BOPTrees)((BOPTrees)primLeaves.func_177229_b(((BlockBOPLeaves)primLeaves.func_177230_c()).variantProperty)))) {
                            case TINTED: {
                                if (inWorld && TreeHelper.isLeaves((Block)block)) {
                                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                                }
                                return 0xFF00FF;
                            }
                            case OVERLAY: {
                                if (!inWorld || tintIndex != 0) break;
                                if (TreeHelper.isLeaves((Block)block)) {
                                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                                }
                                return 0xFF00FF;
                            }
                        }
                        return 0xFFFFFF;
                    }
                    if (TreeHelper.isLeaves((Block)block)) {
                        return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
        }
    }

    public void registerClientEventHandlers() {
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(ItemMapleSeed.EntityItemMapleSeed.class, (IRenderFactory)new RenderMapleSeed.Factory());
        RenderingRegistry.registerEntityRenderingHandler(ItemMagicSeed.EntityItemMagicSeed.class, (IRenderFactory)new RenderMagicSeed.Factory());
    }
}

