/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.client.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderingUtils {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static float FLUID_OFFSET = 0.005f;

    public static void render3DItem(EntityItem item, float angle) {
        GL11.glPushMatrix();
        item.field_70290_d = 0.0f;
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        mc.func_175598_ae().func_188391_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
        GL11.glPopMatrix();
    }

    private static void setupGlTranslucent() {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    private static void renderTranslucent(BufferBuilder vertex, double startX, double startY, double startZ, double endX, double endY, double endZ, double rotationX, double rotationY, double rotationZ) {
        GL11.glPushMatrix();
        GL11.glRotated((double)rotationX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotationY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotationZ, (double)0.0, (double)0.0, (double)1.0);
        GL11.glPushMatrix();
        for (int j = 0; j < 4; ++j) {
            RenderingUtils.drawTranslucent(vertex, startX, startY, startZ, endX, endY, endZ);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private static void drawTranslucent(BufferBuilder vertex, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        vertex.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertex.func_181662_b(-startX, startY, -startZ).func_181669_b(100, 0, 0, 255).func_181675_d();
        vertex.func_181662_b(startX, startY, -startZ).func_181669_b(0, 100, 0, 255).func_181675_d();
        vertex.func_181662_b(endX, endY, -endZ).func_181669_b(0, 0, 100, 255).func_181675_d();
        vertex.func_181662_b(-endX, endY, -endZ).func_181669_b(40, 20, 255, 255).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderBeamAt(Entity entity, double startX, double startY, double startZ, double endX, double endY, double endZ, double rotationX, double rotationY, double rotationZ) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)startX, (double)startY, (double)startZ);
        GL11.glPushAttrib((int)1048575);
        RenderingUtils.setupGlTranslucent();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertex = tessellator.func_178180_c();
        RenderingUtils.renderTranslucent(vertex, startX, startY, startZ, endX, endY, endZ, rotationX, rotationY, rotationZ);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double x2, double y2, float red, float green, float blue, float lineWidth) {
        int existed = ClientHelper.player().field_70173_aa;
        float alpha = 0.3f + MathHelper.func_76126_a((float)((float)((double)existed + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double z, double x2, double y2, double z2, float red, float green, float blue, float lineWidth) {
        int count = ClientHelper.player().field_70173_aa;
        float alpha = 0.3f + MathHelper.func_76126_a((float)((float)((double)count + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawLineNoFade(double x, double y, double x2, double y2, float red, float green, float blue, float lineWidth, float alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawLineNoFade(double x, double y, double z, double x2, double y2, double z2, float red, float green, float blue, float lineWidth, float alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double x2, double y2, float red, float green, float blue, float lineWidth, float fadeSpeed) {
        int count = ClientHelper.player().field_70173_aa;
        float alpha = fadeSpeed + MathHelper.func_76126_a((float)((float)((double)count + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double z, double x2, double y2, double z2, float red, float green, float blue, float lineWidth, float fadeSpeed) {
        int existed = ClientHelper.player().field_70173_aa;
        float alpha = 0.3f + MathHelper.func_76126_a((float)((float)((double)existed + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawRect(double x, double y, double width, double height, float red, float green, float blue, float lineWidth) {
        RenderingUtils.drawLine(x, y, x + width, y, red, green, blue, lineWidth, 0.0f);
        RenderingUtils.drawLine(x + width, y, x + width, y + width, red, green, blue, lineWidth, 0.0f);
        RenderingUtils.drawLine(x + width, y + width, x, y + width, red, green, blue, lineWidth, 0.0f);
        RenderingUtils.drawLine(x, y + width, x, y, red, green, blue, lineWidth, 0.0f);
    }

    public static void drawRectFadeless(double x, double y, double width, double height, float red, float green, float blue, float lineWidth, float alpha) {
        RenderingUtils.drawLineNoFade(x, y, x + width, y, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y, x + width, y + width, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y + width, x, y + width, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x, y + width, x, y, red, green, blue, lineWidth, alpha);
    }

    public static void drawRect(double x, double y, double width, double height, float red, float green, float blue, float lineWidth, float fadeSpeed) {
        RenderingUtils.drawLine(x, y, x + width, y, red, green, blue, lineWidth, fadeSpeed);
        RenderingUtils.drawLine(x + width, y, x + width, y + width, red, green, blue, lineWidth, fadeSpeed);
        RenderingUtils.drawLine(x + width, y + width, x, y + width, red, green, blue, lineWidth, fadeSpeed);
        RenderingUtils.drawLine(x, y + width, x, y, red, green, blue, lineWidth, fadeSpeed);
    }

    public static void drawRect(double x, double y, double z, double width, double height, float red, float green, float blue, float lineWidth) {
        RenderingUtils.drawLine(x, y, z, x + width, y, z, red, green, blue, lineWidth);
        RenderingUtils.drawLine(x + width, y, z, x + width, y + width, z, red, green, blue, lineWidth);
        RenderingUtils.drawLine(x + width, y + width, z, x, y + width, z, red, green, blue, lineWidth);
        RenderingUtils.drawLine(x, y + width, z, x, y, z, red, green, blue, lineWidth);
    }

    public static void drawRectNoFade(double x, double y, double z, double width, double height, float red, float green, float blue, float lineWidth, float alpha) {
        RenderingUtils.drawLineNoFade(x, y, z, x + width, y, z, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y, z, x + width, y + width, z, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y + width, z, x, y + width, z, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x, y + width, z, x, y, z, red, green, blue, lineWidth, alpha);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double w, double h, double d) {
        double wd = (1.0 - w) / 2.0;
        double hd = (1.0 - h) / 2.0;
        double dd = (1.0 - d) / 2.0;
        RenderingUtils.renderFluidCuboid(fluid, pos, x, y, z, wd, hd, dd, 1.0 - wd, 1.0 - hd, 1.0 - dd);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        int color = fluid.getFluid().getColor(fluid);
        RenderingUtils.renderFluidCuboid(fluid, pos, x, y, z, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        RenderingUtils.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int brightness = RenderingUtils.mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        RenderingUtils.pre(x, y, z);
        TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        RenderingUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
        RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
        RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
        RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
        RenderingUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        tessellator.func_78381_a();
        RenderingUtils.post();
    }

    public static void renderStackedFluidCuboid(FluidStack fluid, double px, double py, double pz, BlockPos pos, BlockPos from, BlockPos to, double ymin, double ymax) {
        RenderingUtils.renderStackedFluidCuboid(fluid, px, py, pz, pos, from, to, ymin, ymax, FLUID_OFFSET);
    }

    public static void renderStackedFluidCuboid(FluidStack fluid, double px, double py, double pz, BlockPos pos, BlockPos from, BlockPos to, double ymin, double ymax, float offsetToBlockEdge) {
        int i;
        if (ymin >= ymax) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        RenderingUtils.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int color = fluid.getFluid().getColor(fluid);
        int brightness = RenderingUtils.mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        RenderingUtils.pre(px, py, pz);
        GlStateManager.func_179109_b((float)from.func_177958_n(), (float)from.func_177956_o(), (float)from.func_177952_p());
        TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        if (still == null) {
            still = mc.func_147117_R().func_174944_f();
        }
        if (flowing == null) {
            flowing = mc.func_147117_R().func_174944_f();
        }
        int xd = to.func_177958_n() - from.func_177958_n();
        int yminInt = (int)ymin;
        int yd = (int)(ymax - (double)yminInt);
        if (ymax % 1.0 == 0.0) {
            --yd;
        }
        int zd = to.func_177952_p() - from.func_177952_p();
        double xmin = offsetToBlockEdge;
        double xmax = (double)xd + 1.0 - (double)offsetToBlockEdge;
        double zmin = offsetToBlockEdge;
        double zmax = (double)zd + 1.0 - (double)offsetToBlockEdge;
        double[] xs = new double[2 + xd];
        double[] ys = new double[2 + yd];
        double[] zs = new double[2 + zd];
        xs[0] = xmin;
        for (i = 1; i <= xd; ++i) {
            xs[i] = i;
        }
        xs[xd + 1] = xmax;
        ys[0] = ymin;
        for (i = 1; i <= yd; ++i) {
            ys[i] = i + yminInt;
        }
        ys[yd + 1] = ymax;
        zs[0] = zmin;
        for (i = 1; i <= zd; ++i) {
            zs[i] = i;
        }
        zs[zd + 1] = zmax;
        for (int y = 0; y <= yd; ++y) {
            for (int z = 0; z <= zd; ++z) {
                for (int x = 0; x <= xd; ++x) {
                    double x1 = xs[x];
                    double x2 = xs[x + 1] - x1;
                    double y1 = ys[y];
                    double y2 = ys[y + 1] - y1;
                    double z1 = zs[z];
                    double z2 = zs[z + 1] - z1;
                    if (x == 0) {
                        RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.WEST, color, brightness, true);
                    }
                    if (x == xd) {
                        RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.EAST, color, brightness, true);
                    }
                    if (y == 0) {
                        RenderingUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.DOWN, color, brightness, false);
                    }
                    if (y == yd) {
                        RenderingUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.UP, color, brightness, false);
                    }
                    if (z == 0) {
                        RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.NORTH, color, brightness, true);
                    }
                    if (z != zd) continue;
                    RenderingUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.SOUTH, color, brightness, true);
                }
            }
        }
        tessellator.func_78381_a();
        RenderingUtils.post();
    }

    public static void putTexturedCuboid(BufferBuilder renderer, ResourceLocation location, double x1, double y1, double z1, double x2, double y2, double z2, int color, int brightness) {
        boolean flowing = false;
        TextureAtlasSprite sprite = mc.func_147117_R().getTextureExtry(location.toString());
        RenderingUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, flowing);
        RenderingUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, flowing);
        RenderingUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, flowing);
        RenderingUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, flowing);
        RenderingUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, flowing);
        RenderingUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, flowing);
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int color, int brightness, boolean flowing) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderingUtils.putTexturedQuad(renderer, sprite, x, y, z, w, h, d, face, r, g, b, a, l1, l2, flowing);
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int r, int g, int b, int a, int light1, int light2, boolean flowing) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double zt2;
        double yt2;
        double xt2;
        if (sprite == null) {
            return;
        }
        double size = 16.0;
        if (flowing) {
            size = 8.0;
        }
        double x1 = x;
        double x2 = x + w;
        double y1 = y;
        double y2 = y + h;
        double z1 = z;
        double z2 = z + d;
        double xt1 = x1 % 1.0;
        for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
        }
        double yt1 = y1 % 1.0;
        for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
        }
        double zt1 = z1 % 1.0;
        for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
        }
        if (flowing) {
            double tmp = 1.0 - yt1;
            yt1 = 1.0 - yt2;
            yt2 = tmp;
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(xt1 * size);
                maxU = sprite.func_94214_a(xt2 * size);
                minV = sprite.func_94207_b(zt1 * size);
                maxV = sprite.func_94207_b(zt2 * size);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(xt2 * size);
                maxU = sprite.func_94214_a(xt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(zt2 * size);
                maxU = sprite.func_94214_a(zt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (face) {
            case DOWN: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
            }
        }
    }

    public static void pre(double x, double y, double z) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
    }

    public static void post() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public static void setColorRGB(int color) {
        RenderingUtils.setColorRGBA(color | 0xFF000000);
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderingUtils.alpha(color) / 255.0f;
        float r = (float)RenderingUtils.red(color) / 255.0f;
        float g = (float)RenderingUtils.green(color) / 255.0f;
        float b = (float)RenderingUtils.blue(color) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void setBrightness(BufferBuilder renderer, int brightness) {
        renderer.func_178962_a(brightness, brightness, brightness, brightness);
    }

    public static int compose(int r, int g, int b, int a) {
        int rgb = a;
        rgb = (rgb << 8) + r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    public static float[] directionalVelocitiesOfMagnitude(Vec3i vector, float magnitude) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (vector.func_177958_n() != 0) {
            x = magnitude;
            if (vector.func_177958_n() < 0) {
                x = -x;
            }
        }
        if (vector.func_177956_o() != 0) {
            y = magnitude;
            if (vector.func_177956_o() < 0) {
                y = -y;
            }
        }
        if (vector.func_177952_p() != 0) {
            z = magnitude;
            if (vector.func_177952_p() < 0) {
                z = -z;
            }
        }
        return new float[]{x, y, z};
    }
}

