/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.subblocksystem.blocks;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.subblocksystem.blocks.BlockSubBlockHolder;
import com.teamacronymcoders.base.subblocksystem.blocks.ISubBlock;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SubBlockBase
implements ISubBlock {
    private String name;
    private ResourceLocation textureLocation;
    private Block block;
    private int meta;

    public SubBlockBase(String name) {
        this.name = name;
        this.textureLocation = new ResourceLocation("base", this.getModelPrefix() + name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnLocalizedName() {
        return "base.subblock." + this.name;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    @Override
    public int getColor() {
        return -1;
    }

    @Override
    public void getDrops(int fortune, List<ItemStack> itemStacks) {
        itemStacks.add(this.getItemStack());
    }

    @Override
    public void setRecipes(List<IRecipe> recipes) {
    }

    @Override
    public String getOreDict() {
        return "";
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack(this.block, 1, this.meta);
    }

    @Override
    public Material getMaterial() {
        return Material.field_151573_f;
    }

    @Override
    @Nonnull
    public IBlockState getBlockState() {
        return this.block.func_176223_P().func_177226_a((IProperty)BlockSubBlockHolder.SUB_BLOCK_NUMBER, (Comparable)Integer.valueOf(this.meta));
    }

    public Block getBlock() {
        return this.block;
    }

    @Override
    public void setBlock(Block block) {
        this.block = block;
    }

    @Override
    public void setMeta(int meta) {
        this.meta = meta;
    }

    @Override
    public void onNeighborChange(World world, BlockPos pos, Block block, BlockPos fromPos) {
    }

    @Override
    public IGeneratedModel getGeneratedModel() {
        TemplateFile templateFile = TemplateManager.getTemplateFile("sub_block_state");
        HashMap replacements = Maps.newHashMap();
        replacements.put("texture", new ResourceLocation(this.getTextureLocation().func_110624_b(), "blocks/" + this.getTextureLocation().func_110623_a()).toString());
        templateFile.replaceContents(replacements);
        return new GeneratedModel(this.getModelPrefix() + this.getUnLocalizedName(), ModelType.BLOCKSTATE, templateFile.getFileContents());
    }

    protected void spawnItemStackEntity(World world, ItemStack itemStack, BlockPos blockPos) {
        EntityItem entityItem = new EntityItem(world, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p(), itemStack);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entityItem);
        }
    }

    protected String getModelPrefix() {
        return "";
    }
}

