/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import rustic.common.crafting.EvaporatingBasinRecipe;
import rustic.common.crafting.Recipes;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.EvaporatingBasin")
public class EvaporatingBasin {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack input) {
        EvaporatingBasinRecipe r = new EvaporatingBasinRecipe(CraftTweakerHelper.toStack(output), CraftTweakerHelper.toFluidStack(input));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (!CraftTweakerHelper.toStack(output).func_190926_b()) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<EvaporatingBasinRecipe> it = Recipes.evaporatingRecipes.iterator();
            while (it.hasNext()) {
                EvaporatingBasinRecipe r = it.next();
                if (r == null || r.getResult() == null || !r.getResult().func_77969_a(this.output)) continue;
                it.remove();
            }
        }

        public String describe() {
            return "Removing Evaporating Recipes for Item " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final EvaporatingBasinRecipe recipe;

        public Add(EvaporatingBasinRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.evaporatingRecipes.add(this.recipe);
        }

        public String describe() {
            return "Adding Evaporating Recipe for Item " + this.recipe.getResult().func_82833_r();
        }
    }
}

