/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.crafting.CrushingTubRecipe;
import rustic.common.crafting.Recipes;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.CrushingTub")
public class CrushingTub {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, IItemStack byproduct, IItemStack input) {
        CrushingTubRecipe r = new CrushingTubRecipe(CraftTweakerHelper.toFluidStack(output), CraftTweakerHelper.toStack(input), CraftTweakerHelper.toStack(byproduct));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output, IItemStack input) {
        if (CraftTweakerHelper.toFluidStack(output) != null && !CraftTweakerHelper.toStack(input).func_190926_b()) {
            CraftTweakerAPI.apply((IAction)new RemoveFluid(CraftTweakerHelper.toFluidStack(output), CraftTweakerHelper.toStack(input)));
        }
    }

    private static class RemoveFluid
    implements IAction {
        private final FluidStack output;
        private final ItemStack input;

        public RemoveFluid(FluidStack output, ItemStack input) {
            this.output = output;
            this.input = input;
        }

        public void apply() {
            Iterator<CrushingTubRecipe> it = Recipes.crushingTubRecipes.iterator();
            while (it.hasNext()) {
                CrushingTubRecipe r = it.next();
                if (r == null || r.getResult() == null || !r.getResult().isFluidEqual(this.output) || !r.getInput().func_77969_a(this.input)) continue;
                it.remove();
            }
        }

        public String describe() {
            return "Removing Crushing Tub Recipes for Fluid " + this.output.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        private final CrushingTubRecipe recipe;

        public Add(CrushingTubRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.crushingTubRecipes.add(this.recipe);
        }

        public String describe() {
            return "Adding Crushing Tub Recipe for Fluid " + this.recipe.getResult().getLocalizedName();
        }
    }
}

