/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.crafting.CrushingTubRecipe;
import rustic.common.crafting.Recipes;

public class TileEntityCrushingTub
extends TileFluidHandler {
    public static int capacity = 8000;
    public ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IBlockState state = TileEntityCrushingTub.this.field_145850_b.func_180495_p(TileEntityCrushingTub.this.field_174879_c);
            TileEntityCrushingTub.this.field_145850_b.func_175641_c(TileEntityCrushingTub.this.field_174879_c, TileEntityCrushingTub.this.func_145838_q(), 1, 0);
            TileEntityCrushingTub.this.func_145831_w().func_184138_a(TileEntityCrushingTub.this.field_174879_c, state, state, 3);
            TileEntityCrushingTub.this.field_145850_b.func_175685_c(TileEntityCrushingTub.this.field_174879_c, TileEntityCrushingTub.this.func_145838_q(), true);
            TileEntityCrushingTub.this.func_70296_d();
        }
    };

    public TileEntityCrushingTub() {
        this.tank = new FluidTank(capacity){

            protected void onContentsChanged() {
                TileEntityCrushingTub.this.func_70296_d();
                TileEntityCrushingTub.this.func_145831_w().func_184138_a(TileEntityCrushingTub.this.field_174879_c, TileEntityCrushingTub.this.func_145831_w().func_180495_p(TileEntityCrushingTub.this.field_174879_c), TileEntityCrushingTub.this.func_145831_w().func_180495_p(TileEntityCrushingTub.this.field_174879_c), 2);
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(false);
        this.tank.setCanDrain(true);
    }

    public void crush(EntityLivingBase entity) {
        if (!this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(0);
            for (CrushingTubRecipe recipe : Recipes.crushingTubRecipes) {
                if (!recipe.matches(stack)) continue;
                FluidStack output = recipe.getResult();
                if (this.getAmount() > this.getCapacity() - output.amount) continue;
                this.tank.fillInternal(output, true);
                this.itemStackHandler.extractItem(0, 1, false);
                ItemStack by = recipe.getByproduct().func_77946_l();
                if (!by.func_190926_b()) {
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)by);
                }
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187876_fn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                this.func_70296_d();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        block6: {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem != ItemStack.field_190927_a) {
                if ((FluidUtil.getFluidHandler((ItemStack)heldItem) != null || heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket) && FluidUtil.getFluidContained((ItemStack)heldItem) == null) {
                    boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
                    if (didFill) {
                        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                        this.func_145831_w().func_184138_a(pos, state, state, 3);
                        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                        this.func_70296_d();
                        return true;
                    }
                    break block6;
                } else {
                    player.func_184611_a(hand, this.itemStackHandler.insertItem(0, heldItem, false));
                    this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                    this.func_145831_w().func_184138_a(pos, state, state, 3);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                    this.func_70296_d();
                    return true;
                }
            }
            if (player.func_70093_af() && this.getAmount() > 0) {
                FluidStack drained = this.tank.drainInternal(capacity, true);
                SoundEvent soundevent = drained.getFluid().getEmptySound(drained);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                this.func_145831_w().func_184138_a(pos, state, state, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                this.func_70296_d();
                return true;
            }
        }
        if (this.itemStackHandler.getStackInSlot(0) != ItemStack.field_190927_a && !world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.itemStackHandler.getStackInSlot(0)));
            this.itemStackHandler.setStackInSlot(0, ItemStack.field_190927_a);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
            this.func_145831_w().func_184138_a(pos, state, state, 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        return tag;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.itemStackHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i) == null) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.itemStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }
}

