/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.book.pages;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.client.gui.book.GuiBook;
import rustic.common.book.BookCategory;
import rustic.common.book.BookEntryCategory;
import rustic.common.book.BookManager;
import rustic.common.book.BookPage;

public class BookPageCategories
extends BookPage {
    public BookPageCategories() {
        super(BookManager.categories_entry);
    }

    @Override
    public void drawScreen(GuiBook gui, int mouseX, int mouseY, float partialTicks) {
        int y = gui.guiTop + 12;
        int x = gui.guiLeft + 73;
        gui.drawCenteredText(TextFormatting.UNDERLINE + "" + TextFormatting.BOLD + I18n.func_74838_a((String)BookManager.categories_entry.getName()), x, y, 0);
    }

    @Override
    public void onOpened(GuiBook gui) {
        int y = gui.guiTop + 28;
        int x = gui.guiLeft + 73 - 16;
        for (BookCategory category : BookManager.categories) {
            gui.getButtonList().add(new CategoryButton(gui.nextButtonID(), x, y, 32, gui.getFontRenderer(), category));
            y += 48;
        }
    }

    @Override
    public void onClosed(GuiBook gui) {
        super.onClosed(gui);
    }

    @Override
    public void actionPerformed(GuiBook gui, GuiButton button) {
        if (button instanceof CategoryButton) {
            gui.goToEntry(((CategoryButton)button).getCategoryEntry());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CategoryButton
    extends GuiButton {
        private int ticksHovered;
        private int frame;
        private FontRenderer fontRenderer;
        private BookCategory category;

        public CategoryButton(int buttonId, int x, int y, int width, FontRenderer fontRenderer, BookCategory category) {
            super(buttonId, x, y, width, width, category.getName());
            this.ticksHovered = 0;
            this.frame = 0;
            this.fontRenderer = fontRenderer;
            this.category = category;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                if (flag) {
                    ++this.ticksHovered;
                    if (this.ticksHovered % 2 == 0 && this.frame < 7) {
                        ++this.frame;
                    }
                    String text = I18n.func_74838_a((String)this.field_146126_j);
                    int stringWidth = this.fontRenderer.func_78256_a(text);
                    this.fontRenderer.func_78276_b(text, this.field_146128_h + this.field_146120_f / 2 - stringWidth / 2, this.field_146129_i + this.field_146121_g, 0);
                    GlStateManager.func_179131_c((float)0.171875f, (float)0.4453125f, (float)0.171875f, (float)1.0f);
                } else {
                    this.ticksHovered = 0;
                    if (this.frame > 0) {
                        --this.frame;
                    }
                    GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                mc.func_110434_K().func_110577_a(this.category.getIcon());
                Gui.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)0.0f, (float)((float)this.frame * 32.0f), (int)32, (int)32, (float)32.0f, (float)256.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
            }
        }

        public BookEntryCategory getCategoryEntry() {
            return this.category.getCategoryEntry();
        }
    }
}

