/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks.crops;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.common.blocks.BlockLattice;
import rustic.common.blocks.BlockRope;
import rustic.common.blocks.BlockRopeBase;
import rustic.common.blocks.IColoredBlock;
import rustic.common.blocks.ModBlocks;
import rustic.common.items.ModItems;
import rustic.core.ClientProxy;
import rustic.core.Rustic;

public class BlockGrapeLeaves
extends BlockRopeBase
implements IGrowable,
IColoredBlock {
    public static final PropertyBool GRAPES = PropertyBool.func_177716_a((String)"grapes");
    public static final PropertyInteger DIST = PropertyInteger.func_177719_a((String)"distance", (int)0, (int)1);
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177708_a((String)"axis", EnumFacing.Axis.class, (Predicate)new Predicate<EnumFacing.Axis>(){

        public boolean apply(@Nullable EnumFacing.Axis p_apply_1_) {
            return p_apply_1_ != EnumFacing.Axis.Y;
        }
    });
    public static final AxisAlignedBB BRANCH_Z_AABB = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    public static final AxisAlignedBB BRANCH_X_AABB = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);

    public BlockGrapeLeaves() {
        super(Material.field_151584_j, "grape_leaves", false);
        GameRegistry.findRegistry(Block.class).register((IForgeRegistryEntry)this);
        this.func_149675_a(true);
        this.func_149647_a(Rustic.farmingTab);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIST, (Comparable)Integer.valueOf(0)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue()) {
            stacks.add(new ItemStack((Item)ModItems.GRAPES));
        }
        return stacks;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        super.func_180663_b(world, pos, state);
        world.func_180501_a(pos, ModBlocks.ROPE.func_176223_P().func_177226_a((IProperty)BlockRope.AXIS, (Comparable)axis), 3);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(false)), 3);
            Block.func_180635_a((World)world, (BlockPos)pos.func_177972_a(side), (ItemStack)new ItemStack((Item)ModItems.GRAPES, world.field_73012_v.nextInt(2) + 1));
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)DIST) < 1) {
            return Block.field_185505_j;
        }
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
            return BRANCH_Z_AABB;
        }
        return BRANCH_X_AABB;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @Override
    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ModItems.GRAPES);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing dir = null;
        if (fromPos.func_177958_n() != pos.func_177958_n()) {
            dir = fromPos.func_177958_n() - pos.func_177958_n() < 0 ? EnumFacing.WEST : EnumFacing.EAST;
        } else if (fromPos.func_177956_o() != pos.func_177956_o()) {
            dir = fromPos.func_177956_o() - pos.func_177956_o() < 0 ? EnumFacing.DOWN : EnumFacing.UP;
        } else if (fromPos.func_177952_p() != pos.func_177952_p()) {
            EnumFacing enumFacing = dir = fromPos.func_177952_p() - pos.func_177952_p() < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
        }
        if (dir != null && state.func_177229_b(AXIS) == dir.func_176740_k() && worldIn.func_175623_d(fromPos)) {
            if (dir == EnumFacing.DOWN) {
                this.dropBlock(worldIn, pos, state);
            } else if (!this.isBlockSupported(worldIn, pos, state)) {
                this.dropBlock(worldIn, pos, state);
            }
        }
    }

    @Override
    public boolean isSideSupported(World world, BlockPos pos, IBlockState state, EnumFacing facing) {
        IBlockState testState = world.func_180495_p(pos.func_177972_a(facing));
        boolean isSame = testState.func_177230_c() == state.func_177230_c() && testState.func_177229_b(AXIS) == state.func_177229_b(AXIS);
        boolean isRope = testState.func_177230_c() == ModBlocks.ROPE && state.func_177229_b(AXIS) == testState.func_177229_b((IProperty)BlockRope.AXIS);
        boolean isSideSolid = world.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d(), false);
        boolean isTiedStake = testState.func_177230_c() == ModBlocks.STAKE_TIED;
        boolean isLattice = testState.func_177230_c() instanceof BlockLattice;
        return isSame || isRope || isSideSolid || isTiedStake || isLattice;
    }

    @Override
    public boolean isBlockSupported(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.X) {
            return this.isSideSupported(world, pos, state, EnumFacing.WEST) && this.isSideSupported(world, pos, state, EnumFacing.EAST);
        }
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
            return this.isSideSupported(world, pos, state, EnumFacing.NORTH) && this.isSideSupported(world, pos, state, EnumFacing.SOUTH);
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!this.isBlockSupported(worldIn, pos, state)) {
            this.dropBlock(worldIn, pos, state);
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
            float f;
            int i = (Integer)state.func_177229_b((IProperty)DIST);
            if (i > 0 && !((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue() && worldIn.func_175623_d(pos.func_177977_b())) {
                float f2 = BlockGrapeLeaves.getGrowthChance(this, worldIn, pos);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / f2) + 1) == 0 ? 1 : 0) != 0)) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(true)), 3);
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            } else if (i < 1 && this.canSpread(worldIn, pos, state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / (f = BlockGrapeLeaves.getGrowthChance(this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
                this.spread(worldIn, pos, state);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        return 3.0f;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        if ((Integer)state.func_177229_b((IProperty)DIST) > 0) {
            return (Boolean)state.func_177229_b((IProperty)GRAPES) == false && worldIn.func_175623_d(pos.func_177977_b());
        }
        return this.canSpread(worldIn, pos, state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)DIST) > 0) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.spread(worldIn, pos, state);
        }
    }

    public boolean canSpread(World world, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)DIST) == 0) {
            switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                case X: {
                    return world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177976_e()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS) || world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177974_f()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS);
                }
                case Z: {
                    return world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177978_c()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS) || world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177968_d()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS);
                }
            }
        }
        return false;
    }

    public void spread(World world, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)DIST) < 1) {
            switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                case X: {
                    boolean eastRope;
                    boolean westRope = world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177976_e()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS);
                    boolean bl = eastRope = world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177974_f()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS);
                    if (westRope && eastRope) {
                        this.spreadToValidRope(world, pos, (double)world.field_73012_v.nextFloat() < 0.5 ? pos.func_177976_e() : pos.func_177974_f(), state);
                        break;
                    }
                    if (westRope) {
                        this.spreadToValidRope(world, pos, pos.func_177976_e(), state);
                        break;
                    }
                    if (!eastRope) break;
                    this.spreadToValidRope(world, pos, pos.func_177974_f(), state);
                    break;
                }
                case Z: {
                    boolean southRope;
                    boolean northRope = world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177978_c()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS);
                    boolean bl = southRope = world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177968_d()).func_177229_b((IProperty)BlockRope.AXIS) == state.func_177229_b(AXIS);
                    if (northRope && southRope) {
                        this.spreadToValidRope(world, pos, (double)world.field_73012_v.nextFloat() < 0.5 ? pos.func_177978_c() : pos.func_177968_d(), state);
                        break;
                    }
                    if (northRope) {
                        this.spreadToValidRope(world, pos, pos.func_177978_c(), state);
                        break;
                    }
                    if (!southRope) break;
                    this.spreadToValidRope(world, pos, pos.func_177968_d(), state);
                }
            }
        }
    }

    private void spreadToValidRope(World world, BlockPos origPos, BlockPos newPos, IBlockState state) {
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(newPos).func_177229_b((IProperty)BlockRope.AXIS);
        world.func_180501_a(newPos, this.func_176223_P().func_177226_a(AXIS, (Comparable)axis).func_177226_a((IProperty)DIST, (Comparable)Integer.valueOf(1)), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, DANGLE, DIST, GRAPES});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRope && world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockRope.AXIS) == EnumFacing.Axis.Y) {
            return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    @Override
    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.X;
        int dist = 0;
        boolean grapes = false;
        int i = meta & 1;
        if (i == 0) {
            enumfacing$axis = EnumFacing.Axis.X;
        } else if (i == 1) {
            enumfacing$axis = EnumFacing.Axis.Z;
        }
        i = meta & 2;
        if (i > 0) {
            dist = 1;
        }
        if ((i = meta & 8) > 0) {
            grapes = true;
        }
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)enumfacing$axis).func_177226_a((IProperty)DIST, (Comparable)Integer.valueOf(dist)).func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(grapes));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            i = 0;
        } else if (enumfacing$axis == EnumFacing.Axis.Z) {
            i = 1;
        }
        if ((Integer)state.func_177229_b((IProperty)DIST) == 1) {
            i |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                if (worldIn != null && pos != null) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (!(stack.func_77973_b() instanceof ItemBlock)) {
                    return 0xFFFFFF;
                }
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                IBlockColor blockColor = ((IColoredBlock)state.func_177230_c()).getBlockColor();
                return blockColor == null ? 0xFFFFFF : blockColor.func_186720_a(state, null, null, tintIndex);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientProxy.addColoredBlock(this);
    }
}

