/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockBase;
import rustic.common.network.MessageDismountChair;
import rustic.common.network.PacketHandler;

public class BlockChair
extends BlockBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB CHAIR_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.125, 0.875);

    public BlockChair(String type) {
        super(Material.field_151575_d, "chair_" + type);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CHAIR_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        List chairs;
        if (player.func_174831_c(pos) >= 5.0 || player.func_70093_af() || player.func_184218_aH()) {
            return true;
        }
        if (!world.field_72995_K && (chairs = world.func_72872_a(EntityChair.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)))).isEmpty()) {
            EntityChair chair = new EntityChair(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
            world.func_72838_d((Entity)chair);
            if (player.func_184220_m((Entity)chair)) {
                player.func_70634_a(chair.field_70165_t, chair.field_70163_u, chair.field_70161_v);
            }
        }
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class EntityChair
    extends Entity {
        public EntityChair(World world) {
            super(world);
            this.func_70105_a(0.0f, 0.0f);
        }

        public EntityChair(World world, BlockPos pos, EnumFacing facing) {
            super(world);
            if (facing != null) {
                this.field_70177_z = facing.func_185119_l();
            }
            Vec3i facingVec = facing.func_176730_m();
            double xOffset = (double)facingVec.func_177958_n() * -0.125;
            double zOffset = (double)facingVec.func_177952_p() * -0.125;
            this.func_70107_b((double)pos.func_177958_n() + 0.5 + xOffset, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5 + zOffset);
            this.func_70105_a(0.0f, 0.0f);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            BlockPos pos = this.func_180425_c();
            if (pos != null && !(this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockChair)) {
                this.func_70106_y();
                return;
            }
            List passengers = this.func_184188_bt();
            if (passengers.isEmpty()) {
                this.func_70106_y();
            }
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < passengers.size(); ++i) {
                    Entity passenger = (Entity)passengers.get(i);
                    if (!passenger.func_70093_af() && !(passenger.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) >= 1.0)) continue;
                    this.func_70106_y();
                }
            }
        }

        public boolean func_70075_an() {
            return false;
        }

        protected void func_70088_a() {
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageDismountChair());
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_184190_l(Entity entityToUpdate) {
            entityToUpdate.func_181013_g(this.field_70177_z);
            float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
            float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
            entityToUpdate.field_70126_B += f1 - f;
            entityToUpdate.field_70177_z += f1 - f;
            entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }
}

