/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.RoughMobs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FeatureHelper {
    public static boolean removeTask(EntityCreature entity, Class<? extends EntityAIBase> aiClass) {
        return FeatureHelper.tryRemoveTask(entity, entity.field_70714_bg, aiClass) || FeatureHelper.tryRemoveTask(entity, entity.field_70715_bh, aiClass);
    }

    private static boolean tryRemoveTask(EntityCreature entity, EntityAITasks tasks, Class<? extends EntityAIBase> aiClass) {
        for (EntityAITasks.EntityAITaskEntry ai : tasks.field_75782_a) {
            if (!aiClass.isInstance(ai.field_75733_a)) continue;
            tasks.func_85156_a(ai.field_75733_a);
            return true;
        }
        return false;
    }

    public static boolean addEffect(EntityLivingBase entity, Potion effect, int duration, int startAmplifier, int chance, boolean isIncreasing, int maxAmplifier) {
        PotionEffect active;
        if (entity == null || effect == null || startAmplifier < 0 || chance <= 0 || duration <= 0 || entity.func_70681_au().nextInt(chance) != 0) {
            return false;
        }
        int amplifier = startAmplifier;
        if (isIncreasing && (active = entity.func_70660_b(effect)) != null) {
            if (active.func_76459_b() == duration) {
                return false;
            }
            amplifier = Math.min(startAmplifier + active.func_76458_c() + 1, maxAmplifier);
        }
        entity.func_70690_d(new PotionEffect(effect, duration, amplifier));
        return true;
    }

    public static boolean addEffect(EntityLivingBase entity, Potion effect, int duration, int amplifier, int chance) {
        return FeatureHelper.addEffect(entity, effect, duration, amplifier, chance, false, 127);
    }

    public static boolean addEffect(EntityLivingBase entity, Potion effect, int duration, int amplifier) {
        return FeatureHelper.addEffect(entity, effect, duration, amplifier, 1);
    }

    public static boolean addEffect(EntityLivingBase entity, Potion effect, int duration) {
        return FeatureHelper.addEffect(entity, effect, duration, 0);
    }

    public static void spawnParticle(Entity entity, EnumParticleTypes type, float spread, int amount) {
        Random rnd = entity.field_70170_p.field_73012_v;
        for (int i = 0; i < amount; ++i) {
            double moveX = (rnd.nextDouble() - 0.5) * 2.0 * (double)spread;
            double moveY = -rnd.nextDouble() * (double)spread;
            double moveZ = (rnd.nextDouble() - 0.5) * 2.0 * (double)spread;
            ((WorldServer)entity.field_70170_p).func_175688_a(type, entity.field_70165_t + (rnd.nextDouble() - 0.5) * (double)entity.field_70130_N, entity.field_70163_u + rnd.nextDouble() * (double)entity.field_70131_O - 0.25, entity.field_70161_v + (rnd.nextDouble() - 0.5) * (double)entity.field_70130_N, moveX, moveY, moveZ, new int[0]);
        }
    }

    public static void spawnParticle(Entity entity, EnumParticleTypes type, int amount) {
        FeatureHelper.spawnParticle(entity, type, 1.0f, amount);
    }

    public static void spawnParticle(Entity entity, EnumParticleTypes type) {
        FeatureHelper.spawnParticle(entity, type, 1);
    }

    public static void playSound(Entity entity, SoundEvent event, float volume, float pitch) {
        entity.field_70170_p.func_184148_a((EntityPlayer)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, event, entity.func_184176_by(), volume, pitch);
        entity.func_184185_a(event, volume, pitch);
    }

    public static void playSound(Entity entity, SoundEvent event) {
        FeatureHelper.playSound(entity, event, 1.0f, 1.0f);
    }

    public static void knockback(Entity attacker, EntityLivingBase target, float strength, float extraLeap) {
        double xRatio = attacker.field_70165_t - target.field_70165_t;
        double zRatio = attacker.field_70161_v - target.field_70161_v;
        target.func_70653_a(attacker, strength, xRatio, zRatio);
        target.field_70181_x += (double)extraLeap;
    }

    public static List<Block> getBlocksFromNames(String[] breakBlocks) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String name : breakBlocks) {
            Block block = Block.func_149684_b((String)name);
            if (block == null) {
                RoughMobs.logger.error(name + " isn't a valid block!");
                continue;
            }
            blocks.add(block);
        }
        return blocks;
    }

    public static List<EntityEntry> getEntitiesFromNames(String[] entitieNames) {
        ArrayList<EntityEntry> entities = new ArrayList<EntityEntry>();
        for (String name : entitieNames) {
            EntityEntry entity = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(name));
            if (entity == null) {
                RoughMobs.logger.error(name + " isn't a valid entity!");
                continue;
            }
            entities.add(entity);
        }
        return entities;
    }

    public static Map<Potion, Integer> getPotionsFromNames(String[] potionNames) {
        HashMap<Potion, Integer> potions = new HashMap<Potion, Integer>();
        for (String name : potionNames) {
            String[] parts = name.split(";");
            if (parts.length < 2) continue;
            Potion potion = Potion.func_180142_b((String)parts[0]);
            if (potion == null) {
                RoughMobs.logger.error(parts[0] + " isn't a valid potion effect!");
                continue;
            }
            try {
                potions.put(potion, Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                RoughMobs.logger.error(parts[1] + " isn't a valid number!");
            }
        }
        return potions;
    }
}

