/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.ai.combat.RoughAISummonSkeleton;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class WitherFeatures
extends EntityFeatures {
    private boolean pushAttackersAway;
    private int summonSkeletonTimer;

    public WitherFeatures() {
        super("wither", EntityWither.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.pushAttackersAway = RoughConfig.getBoolean(this.name, "PushAttackersAway", true, "Set to false to prevent %ss from pushing attackers away");
        this.summonSkeletonTimer = RoughConfig.getInteger(this.name, "SummonSkeletonTimer", 200, 0, Short.MAX_VALUE, "Delay in ticks between each spawned Skeleton\nSet to 0 to disable this feature");
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (entity instanceof EntityLiving && this.summonSkeletonTimer > 0) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAISummonSkeleton((EntityLiving)entity, this.summonSkeletonTimer, true));
        }
    }

    @Override
    public void onDefend(Entity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
        if (this.pushAttackersAway && attacker instanceof EntityLivingBase && attacker == immediateAttacker) {
            FeatureHelper.knockback(target, (EntityLivingBase)attacker, 1.0f, 0.05f);
            attacker.func_70097_a(DamageSource.field_76377_j, 4.0f);
            FeatureHelper.playSound(target, SoundEvents.field_187926_gz, 0.7f, 1.0f);
        }
    }
}

