/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class SlimeFeatures
extends EntityFeatures {
    private int splitChance;
    private float knockBackMultiplier;

    public SlimeFeatures() {
        super("slime", EntitySlime.class, EntityMagmaCube.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.splitChance = RoughConfig.getInteger(this.name, "SplitChance", 6, 0, Short.MAX_VALUE, "Chance (1 in X minus %s size) that a bigger %s summons a baby %s when hit\nSet to 0 to disable this feature");
        this.knockBackMultiplier = RoughConfig.getFloat(this.name, "KnockBackMultiplier", 0.2f, 0.0f, 32767.0f, "Amount of extra knockback a %s deals\nCalculated with this value times the slime size\nSet to 0 to disable this feature");
    }

    @Override
    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
        if (this.knockBackMultiplier > 0.0f && target instanceof EntityLivingBase) {
            FeatureHelper.knockback(attacker, (EntityLivingBase)target, (float)Math.max(this.getSlimeSize(attacker), 1) * this.knockBackMultiplier, 0.3f);
        }
    }

    @Override
    public void onDefend(Entity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
        if (this.splitChance <= 0) {
            return;
        }
        int chance = Math.max(1, this.splitChance - this.getSlimeSize(target));
        if (!this.isSmallSlime(target) && attacker == immediateAttacker && RND.nextInt(chance) == 0) {
            EntitySlime slime = (EntitySlime)EntityRegistry.getEntry(target.getClass()).newInstance(target.func_130014_f_());
            slime.func_70107_b(target.field_70165_t + Math.random() - Math.random(), target.field_70163_u + Math.random(), target.field_70161_v + Math.random() - Math.random());
            slime.func_180482_a(target.func_130014_f_().func_175649_E(target.func_180425_c()), null);
            this.setSlimeSize(slime, 1);
            target.field_70170_p.func_72838_d((Entity)slime);
        }
    }

    private boolean isSmallSlime(Entity entity) {
        return entity instanceof EntitySlime && ((EntitySlime)entity).func_189101_db();
    }

    private int getSlimeSize(Entity entity) {
        return entity instanceof EntitySlime ? ((EntitySlime)entity).func_70809_q() : 2;
    }

    private void setSlimeSize(EntitySlime slime, int size) {
        try {
            Method setSlimeSize = EntitySlime.class.getDeclaredMethod("setSlimeSize", Integer.TYPE, Boolean.TYPE);
            setSlimeSize.setAccessible(true);
            setSlimeSize.invoke((Object)slime, size, true);
        }
        catch (Exception e) {
            try {
                Method setSlimeSize = EntitySlime.class.getDeclaredMethod("func_70799_a", Integer.TYPE, Boolean.TYPE);
                setSlimeSize.setAccessible(true);
                setSlimeSize.invoke((Object)slime, size, true);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

