/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.compat.GameStagesCompat;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.util.Constants;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.world.BlockEvent;

public abstract class EntityFeatures {
    public static final Random RND = new Random();
    public static final int MAX = Short.MAX_VALUE;
    public String name;
    protected List<Class<? extends Entity>> entityClasses;
    protected boolean featuresEnabled;
    protected List<String> entityNames;

    public EntityFeatures(String name, Class<? extends Entity> ... entityClasses) {
        this.name = name;
        this.entityClasses = Arrays.asList(entityClasses);
    }

    public boolean isEntity(Entity creature) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)creature);
        return this.featuresEnabled && loc != null && this.entityNames.contains(loc.toString());
    }

    public void initConfig() {
        if (!this.hasDefaultConfig()) {
            return;
        }
        RoughConfig.getConfig().addCustomCategoryComment(this.name, "Configuration options which affect " + this.name + " features");
        this.featuresEnabled = RoughConfig.getBoolean(this.name, "FeaturesEnabled", true, "Set to false to disable ALL %s features", true);
        this.entityNames = Arrays.asList(RoughConfig.getStringArray(this.name, "Entities", Constants.getRegNames(this.entityClasses).toArray(new String[0]), "Entities which count as %s entities"));
    }

    private boolean hasDefaultConfig() {
        return true;
    }

    public void addFeatures(EntityJoinWorldEvent event, Entity entity) {
    }

    public boolean bossesEnabled(Entity entity) {
        boolean bossStageEnabled = GameStagesCompat.useBossStage();
        if (bossStageEnabled) {
            EntityPlayer playerClosest = entity.field_70170_p.func_72890_a(entity, -1.0);
            return GameStageHelper.hasAnyOf((EntityPlayer)playerClosest, (String[])new String[]{"roughmobsall", "roughmobsboss"});
        }
        return true;
    }

    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
    }

    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
    }

    public void onDefend(Entity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
    }

    public void onDeath(Entity deadEntity, DamageSource source) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            // empty if block
        }
    }

    public void onFall(Entity entity, LivingFallEvent event) {
    }

    public void onBlockBreak(EntityPlayer player, BlockEvent.BreakEvent event) {
    }

    public void preInit() {
    }

    public void postInit() {
    }
}

