/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAIAddEffect;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EndermanFeatures;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class EndermiteFeatures
extends EntityFeatures {
    private boolean teleportAttacker;
    private String immunityItem;
    private boolean witherMobs;
    private Item immunityItemItem;

    public EndermiteFeatures() {
        super("endermite", EntityEndermite.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.teleportAttacker = RoughConfig.getBoolean(this.name, "TeleportAttacker", true, "Set this to false to prevent %ss from teleporting attackers away");
        this.immunityItem = RoughConfig.getString(this.name, "ImmunityItem", "minecraft:ender_eye", "If this item is somewhere in the players inventory, the player becomes immune to teleportation\nLeave this empty to disable this feature");
        this.witherMobs = RoughConfig.getBoolean(this.name, "WitherMobs", true, "Set this to false to prevent %ss from applying the wither effect to near entities");
    }

    @Override
    public void postInit() {
        this.immunityItemItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.immunityItem));
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (this.witherMobs && entity instanceof EntityLiving) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAIAddEffect((EntityLiving)entity, MobEffects.field_82731_v, 6.0));
        }
    }

    @Override
    public void onDefend(Entity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
        if (this.teleportAttacker && attacker instanceof EntityLivingBase) {
            if (this.isImmuneToTeleport(attacker)) {
                attacker.field_70170_p.func_184148_a((EntityPlayer)null, attacker.field_70169_q, attacker.field_70167_r, attacker.field_70166_s, SoundEvents.field_193777_bb, attacker.func_184176_by(), 1.0f, 1.0f);
                attacker.func_184185_a(SoundEvents.field_193777_bb, 1.0f, 1.0f);
            } else {
                EndermanFeatures.teleportRandom((EntityLivingBase)attacker, 16.0);
            }
        }
    }

    private boolean isImmuneToTeleport(Entity attacker) {
        return this.immunityItemItem != null && attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71071_by.func_70431_c(new ItemStack(this.immunityItemItem));
    }
}

