/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EndermanFeatures
extends EntityFeatures {
    private boolean dropEnderpearl;
    private boolean teleportAttacker;
    private String immunityItem;
    private int blindChance;
    private int blindDuration;
    private int stealItemChance;
    private Item immunityItemItem;

    public EndermanFeatures() {
        super("enderman", EntityEnderman.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.dropEnderpearl = RoughConfig.getBoolean(this.name, "DropEnderpearl", true, "Set this to false to prevent endermen from dropping an extra enderpearl on death");
        this.teleportAttacker = RoughConfig.getBoolean(this.name, "TeleportAttacker", true, "Set this to false to prevent endermen from teleporting attackers away");
        this.immunityItem = RoughConfig.getString(this.name, "ImmunityItem", "minecraft:ender_eye", "If this item is somewhere in the players inventory, the player becomes immune to teleportation and item stealing\nLeave this empty to disable this feature");
        this.blindChance = RoughConfig.getInteger(this.name, "BlindChance", 3, 0, Short.MAX_VALUE, "Chance (1 in X) that an %s applies the blindness effect to its target\nSet to 0 to disable this feature");
        this.blindDuration = RoughConfig.getInteger(this.name, "BlindDuration", 200, 1, Short.MAX_VALUE, "Duration in ticks of the applied blindness effect (20 ticks = 1 second)");
        this.stealItemChance = RoughConfig.getInteger(this.name, "StealItemChance", 3, 0, Short.MAX_VALUE, "Chance (1 in X) that an %s steals the targets held or equipped item to drop it on the ground\nSet to 0 to disable this feature");
    }

    @Override
    public void postInit() {
        this.immunityItemItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.immunityItem));
    }

    @Override
    public void onDeath(Entity deadEntity, DamageSource source) {
        if (this.dropEnderpearl) {
            deadEntity.func_145779_a(Items.field_151079_bi, 1);
        }
    }

    @Override
    public void onDefend(Entity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
        if (this.teleportAttacker && attacker instanceof EntityLivingBase) {
            if (this.isImmuneToTeleport(attacker)) {
                FeatureHelper.playSound(attacker, SoundEvents.field_193777_bb);
            } else {
                EndermanFeatures.teleportRandom((EntityLivingBase)attacker, 24.0);
            }
        }
    }

    @Override
    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        if (this.blindChance > 0 && RND.nextInt(this.blindChance) == 0) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, this.blindDuration));
        }
        if (this.stealItemChance > 0 && RND.nextInt(this.stealItemChance) == 0) {
            if (this.isImmuneToTeleport(attacker)) {
                FeatureHelper.playSound(attacker, SoundEvents.field_193777_bb);
            } else {
                this.tryDropHeldItem((EntityLivingBase)target, attacker);
            }
        }
    }

    private void tryDropHeldItem(EntityLivingBase target, Entity attacker) {
        ArrayList<EnumHand> filledHands = new ArrayList<EnumHand>();
        if (!target.func_184614_ca().func_190926_b()) {
            filledHands.add(EnumHand.MAIN_HAND);
        }
        if (!target.func_184592_cb().func_190926_b()) {
            filledHands.add(EnumHand.OFF_HAND);
        }
        if (filledHands.isEmpty()) {
            return;
        }
        EnumHand hand = (EnumHand)filledHands.get(RND.nextInt(filledHands.size()));
        ItemStack heldStack = target.func_184586_b(hand).func_77946_l();
        target.func_184611_a(hand, ItemStack.field_190927_a);
        attacker.func_70099_a(heldStack, (float)(Math.random() + 0.5));
    }

    public static boolean teleportRandom(EntityLivingBase entity) {
        return EndermanFeatures.teleportRandom(entity, 64.0);
    }

    public static boolean teleportRandom(EntityLivingBase entity, double multi) {
        double z;
        double y;
        if (entity == null || entity instanceof FakePlayer || entity.field_70128_L) {
            return false;
        }
        double x = entity.field_70165_t + (RND.nextDouble() - 0.5) * multi;
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y = entity.field_70163_u + (double)(RND.nextInt(64) - 32), z = entity.field_70161_v + (RND.nextDouble() - 0.5) * multi, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event == null || entity == null) {
            return false;
        }
        boolean flag = entity.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            FeatureHelper.playSound((Entity)entity, SoundEvents.field_187534_aX);
        }
        return flag;
    }

    private boolean isImmuneToTeleport(Entity attacker) {
        return this.immunityItemItem != null && attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71071_by.func_70431_c(new ItemStack(this.immunityItemItem));
    }
}

