/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.entities;

import com.p1ut0nium.roughmobsrevamped.entities.EntityHostileBat;
import com.p1ut0nium.roughmobsrevamped.entities.IBoss;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.util.DamageSourceFog;
import com.p1ut0nium.roughmobsrevamped.util.Helpers;
import com.p1ut0nium.roughmobsrevamped.util.handlers.FogEventHandler;
import com.p1ut0nium.roughmobsrevamped.util.handlers.SoundHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class BossZombie
extends EntityZombie
implements IBoss {
    private static boolean BATSWARM_ENABLED = BossHelper.bossBatSwarmEnabled;
    private static int BATSWARM_ATTACK_RANGE = BossHelper.bossBatSwarmRange;
    private static int BATSWARM_MINIONS_MAX = BossHelper.bossBatSwarmCount;
    private static int BATSWARM_DELAY = BossHelper.bossBatSwarmDelay * 20;
    private List<EntityHostileBat> batMinions = new ArrayList<EntityHostileBat>();
    private static int batSwarmTick;
    private static boolean FOG_DOT_ENABLED;
    private static boolean FOG_WARNING_ENABLED;
    private static int FOG_MAX_DISTANCE;
    private static int FOG_DOT_DELAY;
    private static int FOG_WARNING_TIME;
    private HashMap<String, Long> playersWarned = new HashMap();
    private List<EntityPlayer> playersInFog = new ArrayList<EntityPlayer>();
    private TextComponentString fogWarningMsg;
    private static int fog_dot_tick;

    public BossZombie(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 100;
        fog_dot_tick = 0;
        batSwarmTick = 0;
        this.fogWarningMsg = new TextComponentString("The thick fog reaches out for you... You begin to choke as you move through it.\nPerhaps you should find the source of the poisonous mist, or flee to safety.");
        this.fogWarningMsg.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.field_70170_p.field_72995_K && this.field_70163_u >= (double)this.field_70170_p.func_181545_F() && this.field_70170_p.func_175678_i(this.func_180425_c())) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, true));
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("entity.lightning.thunder"));
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundEvent, SoundCategory.AMBIENT, 100.0f, 1.0f, true);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer closetPlayer = this.field_70170_p.func_184136_b((Entity)this, (double)FOG_MAX_DISTANCE);
            if ((batSwarmTick = Math.max(batSwarmTick - 1, 0)) == 0) {
                batSwarmTick = BATSWARM_DELAY;
                if (BATSWARM_ENABLED && closetPlayer != null && this.func_70685_l((Entity)closetPlayer) && closetPlayer.func_70032_d((Entity)this) <= (float)BATSWARM_ATTACK_RANGE && this.batMinions.isEmpty()) {
                    for (int i = 0; i < BATSWARM_MINIONS_MAX; ++i) {
                        EntityHostileBat bat = new EntityHostileBat(this.field_70170_p);
                        bat.func_70107_b(this.field_70165_t + Math.random() - Math.random(), this.field_70163_u + Math.random(), this.field_70161_v + Math.random() - Math.random());
                        bat.func_180482_a(this.func_130014_f_().func_175649_E(this.func_180425_c()), null);
                        this.field_70170_p.func_72838_d((Entity)bat);
                        bat.setIsBatHanging(false);
                        bat.setBoss(this);
                        this.batMinions.add(bat);
                    }
                    this.playSoundBatSwarm();
                }
            }
            if (!this.batMinions.isEmpty()) {
                for (EntityHostileBat bat : this.batMinions) {
                    if (!bat.field_70128_L) continue;
                    this.batMinions.remove((Object)bat);
                    break;
                }
            }
            if (FOG_DOT_ENABLED) {
                List playersInRange = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g((double)FOG_MAX_DISTANCE));
                if (Helpers.containsInstance(playersInRange, EntityPlayer.class)) {
                    for (EntityPlayer player : playersInRange) {
                        if (this.playersInFog.contains(player)) continue;
                        this.playersInFog.add(player);
                        if (!FOG_WARNING_ENABLED) continue;
                        if (!this.playersWarned.containsKey(player.func_70005_c_())) {
                            this.playersWarned.put(player.func_70005_c_(), this.field_70170_p.func_72820_D() + (long)FOG_WARNING_TIME);
                            player.func_145747_a((ITextComponent)this.fogWarningMsg);
                            continue;
                        }
                        if (!this.playersWarned.containsKey(player.func_70005_c_()) || this.field_70170_p.func_72820_D() < this.playersWarned.get(player.func_70005_c_())) continue;
                        this.playersWarned.replace(player.func_70005_c_(), this.field_70170_p.func_72820_D() + (long)FOG_WARNING_TIME);
                        player.func_145747_a((ITextComponent)this.fogWarningMsg);
                    }
                    Iterator<EntityPlayer> playersInFogIterator = this.playersInFog.iterator();
                    while (playersInFogIterator.hasNext()) {
                        EntityPlayer playerInFog = playersInFogIterator.next();
                        if (Helpers.containsPlayer(playersInRange, playerInFog)) continue;
                        playersInFogIterator.remove();
                    }
                    if (fog_dot_tick == FOG_DOT_DELAY) {
                        fog_dot_tick = 0;
                    }
                    if (fog_dot_tick == 0) {
                        for (EntityPlayer player : playersInRange) {
                            player.func_70097_a(DamageSourceFog.POISONOUS_FOG, 0.0f);
                        }
                    }
                    ++fog_dot_tick;
                } else if (!Helpers.containsInstance(playersInRange, EntityPlayer.class)) {
                    this.playersInFog.clear();
                }
            }
        }
        super.func_70636_d();
    }

    private void playSoundBatSwarm() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundHandler.ENTITY_BOSS_BATSWARM, 1.0f, 1.0f);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        batSwarmTick = BATSWARM_DELAY;
        if (!this.batMinions.isEmpty()) {
            for (EntityHostileBat bat : this.batMinions) {
                bat.func_70106_y();
            }
        }
        FogEventHandler.bossDied = true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.ENTITY_BOSS_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.ENTITY_BOSS_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186383_ah;
    }

    static {
        FOG_DOT_ENABLED = BossHelper.bossFogDoTEnabled;
        FOG_WARNING_ENABLED = BossHelper.bossFogDoTWarning;
        FOG_MAX_DISTANCE = BossHelper.bossFogMaxDistance;
        FOG_DOT_DELAY = BossHelper.bossFogDoTDelay * 20;
        FOG_WARNING_TIME = BossHelper.bossFogDoTWarningTime * 20;
    }
}

