/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util.xml;

import com.ldtteam.blockout.util.NBTType;
import com.ldtteam.blockout.util.xml.XMLStreamSupport;
import com.ldtteam.jvoxelizer.util.nbt.INBTBase;
import com.ldtteam.jvoxelizer.util.nbt.INBTByte;
import com.ldtteam.jvoxelizer.util.nbt.INBTCompound;
import com.ldtteam.jvoxelizer.util.nbt.INBTList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public final class XMLToNBT {
    private static final Pattern DOUBLE_PATTERN_NOSUFFIX = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private static final Map<Pattern, NBTType> TYPE_MATCHING_PATTERNS = new LinkedHashMap<Pattern, NBTType>();
    private static final Map<NBTType, Function<Node, INBTBase>> TYPE_CONVERSION_FUNCTIONS = new HashMap<NBTType, Function<Node, INBTBase>>();

    private XMLToNBT() {
        throw new IllegalArgumentException("Utility class: XMLToNBT");
    }

    public static final INBTBase fromXML(@NotNull Node node) throws IllegalArgumentException {
        return TYPE_CONVERSION_FUNCTIONS.get(XMLToNBT.getNBTType(node)).apply(node);
    }

    private static INBTBase convertToByteArray(@NotNull Node node) {
        byte[] bytes = ArrayUtils.toPrimitive((Byte[])XMLStreamSupport.streamChildren(node).filter(child -> child.getNodeType() != 8).filter(child -> child.getNodeType() != 3).map(TYPE_CONVERSION_FUNCTIONS.get(NBTType.TAG_BYTE)::apply).map(nbtBase -> (INBTByte)nbtBase).map(INBTByte::getValue).collect(Collectors.toList()).toArray(new Byte[0]));
        return INBTBase.create((byte[])bytes);
    }

    private static <T extends INBTBase> INBTBase convertFromValue(@NotNull Node node, @NotNull Function<String, T> converter) {
        if (node.getAttributes().getLength() != 1) {
            throw new IllegalArgumentException(String.format("Too many or not enough attributes on Node: %s only value is valid.", node.toString()));
        }
        Node valueNode = node.getAttributes().getNamedItem("value");
        return (INBTBase)converter.apply(valueNode.getNodeValue());
    }

    private static INBTBase convertToList(@NotNull Node node) {
        INBTList list = INBTBase.create((Iterable)XMLStreamSupport.streamChildren(node).filter(child -> child.getNodeType() != 8).filter(child -> child.getNodeType() != 3).map(child -> TYPE_CONVERSION_FUNCTIONS.get(XMLToNBT.getNBTType(child)).apply((Node)child)).collect(Collectors.toList()));
        return list;
    }

    private static final NBTType getNBTType(@NotNull Node node) throws IllegalArgumentException {
        if (!node.hasAttributes()) {
            if (!node.hasChildNodes()) {
                throw new IllegalArgumentException(String.format("Can not determine NBT Type from node: %s", node.toString()));
            }
            long childrenTypeCount = XMLStreamSupport.streamChildren(node).filter(child -> child.getNodeType() != 3).filter(child -> child.getNodeType() != 8).map(XMLToNBT::getNBTType).distinct().count();
            long childrenNameCount = XMLStreamSupport.streamChildren(node).filter(child -> child.getNodeType() != 3).filter(child -> child.getNodeType() != 8).map(Node::getNodeName).distinct().count();
            if (childrenNameCount == 1L && childrenTypeCount == 1L) {
                NBTType type = XMLStreamSupport.streamChildren(node).filter(child -> child.getNodeType() != 3).filter(child -> child.getNodeType() != 8).map(XMLToNBT::getNBTType).distinct().findFirst().get();
                if (type == NBTType.TAG_BYTE) {
                    return NBTType.TAG_BYTE_ARRAY;
                }
                return NBTType.TAG_LIST;
            }
            return NBTType.TAG_COMPOUND;
        }
        if (node.hasChildNodes()) {
            throw new IllegalArgumentException(String.format("Can not determine NBT Type from node: %s. A node with children is not allowed to have attributes.", node.toString()));
        }
        if (node.getAttributes().getLength() > 1) {
            throw new IllegalArgumentException(String.format("Too many attributes on Node: %s only none or value are valid.", node.toString()));
        }
        Node valueNode = node.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            throw new IllegalArgumentException(String.format("No value attribute specified on node: %s", node.toString()));
        }
        return TYPE_MATCHING_PATTERNS.entrySet().stream().filter(tmpe -> ((Pattern)tmpe.getKey()).matcher(valueNode.getNodeValue()).matches()).map(Map.Entry::getValue).findFirst().orElse(NBTType.TAG_STRING);
    }

    private static final INBTBase convertToNBTTagCompound(@NotNull Node node) {
        INBTCompound compound = INBTBase.create();
        XMLStreamSupport.streamChildren(node).filter(child -> child.getNodeType() != 8).filter(child -> child.getNodeType() != 3).forEach(child -> {
            INBTBase nbtBase = TYPE_CONVERSION_FUNCTIONS.get(XMLToNBT.getNBTType(child)).apply((Node)child);
            String name = child.getNodeName();
            if (compound.containsKey((Object)name)) {
                throw new IllegalArgumentException(String.format("Given node contains multiple entries with the same key: %s", name));
            }
            compound.put((Object)name, (Object)nbtBase);
        });
        return compound;
    }

    static {
        TYPE_MATCHING_PATTERNS.put(DOUBLE_PATTERN_NOSUFFIX, NBTType.TAG_DOUBLE);
        TYPE_MATCHING_PATTERNS.put(DOUBLE_PATTERN, NBTType.TAG_DOUBLE);
        TYPE_MATCHING_PATTERNS.put(FLOAT_PATTERN, NBTType.TAG_FLOAT);
        TYPE_MATCHING_PATTERNS.put(BYTE_PATTERN, NBTType.TAG_BYTE);
        TYPE_MATCHING_PATTERNS.put(LONG_PATTERN, NBTType.TAG_LONG);
        TYPE_MATCHING_PATTERNS.put(SHORT_PATTERN, NBTType.TAG_SHORT);
        TYPE_MATCHING_PATTERNS.put(INT_PATTERN, NBTType.TAG_INT);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_BYTE, node -> XMLToNBT.convertFromValue(node, byteString -> INBTBase.create((byte)Byte.parseByte(byteString.replace("b", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_BYTE_ARRAY, XMLToNBT::convertToByteArray);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_COMPOUND, XMLToNBT::convertToNBTTagCompound);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_DOUBLE, node -> XMLToNBT.convertFromValue(node, doubleString -> INBTBase.create((double)Double.parseDouble(doubleString.replace("d", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_FLOAT, node -> XMLToNBT.convertFromValue(node, floatString -> INBTBase.create((float)Float.parseFloat(floatString.replace("f", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_SHORT, node -> XMLToNBT.convertFromValue(node, shortString -> INBTBase.create((short)Short.parseShort(shortString.replace("s", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_LONG, node -> XMLToNBT.convertFromValue(node, longString -> INBTBase.create((long)Long.parseLong(longString.replace("l", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_INT, node -> XMLToNBT.convertFromValue(node, intString -> INBTBase.create((int)Integer.parseInt(intString))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_LIST, XMLToNBT::convertToList);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_STRING, node -> XMLToNBT.convertFromValue(node, INBTBase::create));
    }
}

