/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util.xml;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLStreamSupport {
    private XMLStreamSupport() {
        throw new IllegalArgumentException("Utility Class");
    }

    public static Stream<Node> streamChildren(@NotNull Node node) {
        if (!node.hasChildNodes()) {
            return new ArrayList().stream();
        }
        return XMLStreamSupport.stream(node.getChildNodes());
    }

    public static Stream<Node> stream(@NotNull NodeList nodeList) {
        return StreamSupport.stream(new NodeListSpliterator(nodeList), false);
    }

    private static class NodeListSpliterator
    implements Spliterator<Node> {
        @NotNull
        private final NodeList nodeList;
        private int index = 0;

        public NodeListSpliterator(@NotNull NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Node> action) {
            if (this.index < this.nodeList.getLength()) {
                action.accept(this.nodeList.item(this.index++));
            }
            return this.index < this.nodeList.getLength();
        }

        @Override
        public Spliterator<Node> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.nodeList.getLength() - (this.index + 1);
        }

        @Override
        public int characteristics() {
            return 1301;
        }

        @Override
        public Comparator<? super Node> getComparator() {
            return Node::compareDocumentPosition;
        }
    }
}

