/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util.itemstack;

import com.ldtteam.jvoxelizer.item.IItem;
import com.ldtteam.jvoxelizer.item.IItemStack;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackHelper {
    @Nullable
    public static Comparator<IItemStack> COMPARATOR = new Comparator<IItemStack>(){

        @Override
        public int compare(@NotNull IItemStack pItemStack1, @NotNull IItemStack pItemStack2) {
            if (!pItemStack1.isEmpty() && !pItemStack2.isEmpty()) {
                if (IItem.getIdFromItem((IItem)pItemStack1.getItem()) - IItem.getIdFromItem((IItem)pItemStack2.getItem()) == 0) {
                    if (pItemStack1.getItem() == pItemStack2.getItem()) {
                        if (pItemStack1.getItemDamage() == pItemStack2.getItemDamage()) {
                            if (pItemStack1.hasTagCompound() && pItemStack2.hasTagCompound()) {
                                if (IItemStack.areItemStackTagsEqual((IItemStack)pItemStack1, (IItemStack)pItemStack2)) {
                                    return pItemStack1.getCount() - pItemStack2.getCount();
                                }
                                return pItemStack1.write().hashCode() - pItemStack2.write().hashCode();
                            }
                            if (!pItemStack1.hasTagCompound() && pItemStack2.hasTagCompound()) {
                                return -1;
                            }
                            if (pItemStack1.hasTagCompound() && !pItemStack2.hasTagCompound()) {
                                return 1;
                            }
                            return pItemStack1.getCount() - pItemStack2.getCount();
                        }
                        return pItemStack1.getItemDamage() - pItemStack2.getItemDamage();
                    }
                    return pItemStack1.getItem().getTranslationKey(pItemStack1).compareToIgnoreCase(pItemStack2.getItem().getTranslationKey(pItemStack2));
                }
                return IItem.getIdFromItem((IItem)pItemStack1.getItem()) - IItem.getIdFromItem((IItem)pItemStack2.getItem());
            }
            if (!pItemStack1.isEmpty()) {
                return -1;
            }
            if (!pItemStack2.isEmpty()) {
                return 1;
            }
            return 0;
        }
    };

    private ItemStackHelper() {
        throw new IllegalArgumentException("Utility Class");
    }

    @NotNull
    public static IItemStack cloneItemStack(@NotNull IItemStack pItemStack, int pStackSize) {
        IItemStack tClonedItemStack = pItemStack.copy();
        tClonedItemStack.setCount(pStackSize);
        return tClonedItemStack;
    }

    public static boolean equals(@NotNull IItemStack pItemStack1, @NotNull IItemStack pItemStack2) {
        return COMPARATOR.compare(pItemStack1, pItemStack2) == 0;
    }

    public static boolean equalsIgnoreStackSize(@NotNull IItemStack itemStack1, @NotNull IItemStack itemStack2) {
        if (!itemStack1.isEmpty() && !itemStack2.isEmpty() && IItem.getIdFromItem((IItem)itemStack1.getItem()) - IItem.getIdFromItem((IItem)itemStack2.getItem()) == 0 && itemStack1.getItem() == itemStack2.getItem() && itemStack1.getItemDamage() == itemStack2.getItemDamage()) {
            if (itemStack1.hasTagCompound() && itemStack2.hasTagCompound()) {
                return IItemStack.areItemStackTagsEqual((IItemStack)itemStack1, (IItemStack)itemStack2);
            }
            return true;
        }
        return false;
    }

    public static int mergeStacks(@NotNull IItemStack mergeSource, @NotNull IItemStack mergeTarget, boolean doMerge) {
        if (!ItemStackHelper.canStacksMerge(mergeSource, mergeTarget)) {
            return 0;
        }
        int mergeCount = Math.min(mergeTarget.getMaxStackSize() - mergeTarget.getCount(), mergeSource.getCount());
        if (mergeCount < 1) {
            return 0;
        }
        if (doMerge) {
            mergeTarget.grow(mergeCount);
        }
        return mergeCount;
    }

    public static boolean canStacksMerge(@NotNull IItemStack stack1, @NotNull IItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        if (!stack1.isItemEqual(stack2)) {
            return false;
        }
        return IItemStack.areItemStackTagsEqual((IItemStack)stack1, (IItemStack)stack2);
    }

    public static int compare(@NotNull IItemStack pItemStack1, @NotNull IItemStack pItemStack2) {
        return COMPARATOR.compare(pItemStack1, pItemStack2);
    }

    public static String toString(@NotNull IItemStack pItemStack) {
        if (!pItemStack.isEmpty()) {
            return String.format("%sxitemStack[%s@%s][%s]", pItemStack.getCount(), pItemStack.getTranslationKey(), pItemStack.getItemDamage(), pItemStack.hasTagCompound() ? pItemStack.write().toString() : "");
        }
        return "null";
    }
}

