/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util;

import com.ldtteam.jvoxelizer.client.renderer.bufferbuilder.IBufferBuilder;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.vertexformat.IVertexFormat;
import com.ldtteam.jvoxelizer.client.renderer.tessellator.ITessellator;

public final class Render {
    private static final int ALPHA_SHIFT = 24;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int COLOR_MASK = 255;
    private static final double COLOR_DIVISOR = 255.0;

    private Render() {
    }

    public static void drawOutlineRect(int x1, int y1, int x2, int y2, int color) {
        Render.drawOutlineRect(x1, y1, x2, y2, 1.0f, color);
    }

    public static void drawOutlineRect(int x1, int y1, int x2, int y2, float lineWidth, int color) {
        if (lineWidth <= 0.0f) {
            return;
        }
        float a = (float)((double)(color >> 24 & 0xFF) / 255.0);
        float r = (float)((double)(color >> 16 & 0xFF) / 255.0);
        float g = (float)((double)(color >> 8 & 0xFF) / 255.0);
        float b = (float)((double)(color & 0xFF) / 255.0);
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder vertexBuffer = tessellator.getBuffer();
        vertexBuffer.begin(IOpenGl.getOpenGlLineRenderMode(), IVertexFormat.position());
        IOpenGl.disableTexture2D();
        IOpenGl.glLineWidth((float)lineWidth);
        IOpenGl.color((float)r, (float)g, (float)b, (float)a);
        vertexBuffer.pos((double)x1, (double)y2, 0.0).endVertex();
        vertexBuffer.pos((double)x2, (double)y2, 0.0).endVertex();
        vertexBuffer.pos((double)x2, (double)y1, 0.0).endVertex();
        vertexBuffer.pos((double)x1, (double)y1, 0.0).endVertex();
        tessellator.draw();
        IOpenGl.enableTexture2D();
    }
}

