/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.template;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.template.Template;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.style.resources.TemplateResource;
import com.ldtteam.blockout.template.ITemplateEngine;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SimpleTemplateEngine
implements ITemplateEngine {
    private static SimpleTemplateEngine ourInstance = new SimpleTemplateEngine();
    private final Cache<IIdentifier, TemplateResource> CACHE_TEMPLATE_DATA = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(30L).build();

    private SimpleTemplateEngine() {
    }

    public static SimpleTemplateEngine getInstance() {
        return ourInstance;
    }

    public IUIElement generateFromTemplate(@NotNull IUIElementHost parent, @NotNull IDependencyObject<Object> dataContextProperty, @NotNull IIdentifier resourceId, @NotNull String controlId, @NotNull Function<IUIElementData, IUIElementData> dataOverrideCallback) {
        TemplateResource templateData;
        try {
            templateData = (TemplateResource)this.CACHE_TEMPLATE_DATA.get((Object)resourceId, () -> (TemplateResource)ProxyHolder.getInstance().getStyleManager().getResource(parent.getStyleId(), resourceId));
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(String.format("Failed to load template resource: %s.", resourceId), e);
        }
        return this.generateFromTemplate(parent, dataContextProperty, templateData.getData(), controlId, dataOverrideCallback);
    }

    public IUIElement generateFromTemplate(@NotNull IUIElementHost parent, @NotNull IDependencyObject<Object> dataContextProperty, @NotNull IUIElementData templateData, @NotNull String controlId, @NotNull Function<IUIElementData, IUIElementData> dataOverrideCallback) {
        IUIElement templateCandidate = ProxyHolder.getInstance().getFactoryController().getElementFromData(templateData);
        if (templateCandidate instanceof Template) {
            Template template = (Template)templateCandidate;
            return template.generateInstance(parent, dataContextProperty, controlId, dataOverrideCallback);
        }
        throw new IllegalArgumentException(String.format("The given IUIElementData does not contain a Template as root control.", new Object[0]));
    }
}

