/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.simple;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.style.core.IStyle;
import com.ldtteam.blockout.style.core.IStyleManager;
import com.ldtteam.blockout.style.core.resources.core.IResource;
import com.ldtteam.blockout.style.definitions.ResourceTypeDefinition;
import com.ldtteam.blockout.style.definitions.StyleDefinition;
import com.ldtteam.blockout.style.definitions.StylesDefinition;
import com.ldtteam.blockout.style.definitions.deserializers.ResourceTypeDefinitionDeserializer;
import com.ldtteam.blockout.style.definitions.deserializers.StyleDefinitionDeserializer;
import com.ldtteam.blockout.style.definitions.deserializers.StylesDefinitionDeserializer;
import com.ldtteam.blockout.style.simple.SimpleStyle;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.jvoxelizer.modloader.IModLoader;
import com.ldtteam.jvoxelizer.progressmanager.IProgressBar;
import com.ldtteam.jvoxelizer.progressmanager.IProgressManager;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SimpleFileBasedStyleManager
implements IStyleManager {
    public static final String CONST_STYLE_FILE_PATH = "styles/styles.json";
    private static SimpleFileBasedStyleManager ourInstance = new SimpleFileBasedStyleManager();
    private final Map<IIdentifier, IStyle> styles = new HashMap<IIdentifier, IStyle>();

    private SimpleFileBasedStyleManager() {
    }

    public static SimpleFileBasedStyleManager getInstance() {
        return ourInstance;
    }

    @NotNull
    public ImmutableMap<IIdentifier, IStyle> getStyles() {
        return ImmutableMap.copyOf(this.styles);
    }

    public void loadStyles() {
        this.styles.clear();
        this.initialize();
    }

    public void initialize() {
        IModLoader.instance().getActiveModList().stream().map(modContainer -> modContainer.getModId()).collect(Collectors.toList());
        Set<String> resourceDomains = IModLoader.instance().getActiveModList().stream().map(modContainer -> modContainer.getModId()).collect(Collectors.toSet());
        IProgressBar loadingBar = IProgressManager.push((String)"Loading BlockOut Styles", (int)resourceDomains.size());
        Gson gson = new GsonBuilder().registerTypeAdapter(StylesDefinitionDeserializer.CONST_STYLES_DEFINITION_TYPE, (Object)StylesDefinitionDeserializer.getInstance()).registerTypeAdapter(StyleDefinitionDeserializer.CONST_STYLE_DEFINTION_TYPE, (Object)StyleDefinitionDeserializer.getInstance()).registerTypeAdapter(ResourceTypeDefinitionDeserializer.CONST_RESOURCE_TYPE_DEFINITION_TYPE, (Object)ResourceTypeDefinitionDeserializer.getInstance()).create();
        resourceDomains.forEach(domain -> {
            StylesDefinition stylesDefinition;
            loadingBar.step("Loading styles from: " + domain);
            IIdentifier stylesLocation = IIdentifier.create((String)domain.toLowerCase(), (String)CONST_STYLE_FILE_PATH);
            try {
                stylesDefinition = (StylesDefinition)gson.fromJson((Reader)new InputStreamReader(ProxyHolder.getInstance().getResourceStream(stylesLocation)), StylesDefinitionDeserializer.CONST_STYLES_DEFINITION_TYPE);
            }
            catch (Exception e) {
                return;
            }
            IProgressBar domainLoadingBar = IProgressManager.push((String)String.format("Loading styles from: %s", domain), (int)stylesDefinition.getStyleLocations().size());
            stylesDefinition.getStyleLocations().forEach(styleLocation -> {
                SimpleStyle style;
                StyleDefinition styleDefinition;
                domainLoadingBar.step(String.format("Loading style from: %s", styleLocation));
                try {
                    styleDefinition = (StyleDefinition)gson.fromJson((Reader)new InputStreamReader(ProxyHolder.getInstance().getResourceStream(styleLocation)), StyleDefinitionDeserializer.CONST_STYLE_DEFINTION_TYPE);
                }
                catch (Exception e) {
                    Log.getLogger().error(String.format("Failed to find style: %s", styleLocation.toString()), (Throwable)e);
                    return;
                }
                IProgressBar styleLoadingBar = IProgressManager.push((String)String.format("Loading style: %s in domain: %s", styleDefinition.getStyleId(), domain), (int)styleDefinition.getResourceTypeDefinitionLocations().size());
                Map<IIdentifier, IResource> resourcesForStyle = styleDefinition.getResourceTypeDefinitionLocations().stream().flatMap(resourceTypeLocation -> {
                    ResourceTypeDefinition resourceTypeDefinition;
                    styleLoadingBar.step("Loading resources from: " + resourceTypeLocation);
                    try {
                        resourceTypeDefinition = (ResourceTypeDefinition)gson.fromJson((Reader)new InputStreamReader(ProxyHolder.getInstance().getResourceStream(resourceTypeLocation)), ResourceTypeDefinitionDeserializer.CONST_RESOURCE_TYPE_DEFINITION_TYPE);
                    }
                    catch (Exception e) {
                        Log.getLogger().error(String.format("Failed to find resource type definition: %s", resourceTypeLocation), (Throwable)e);
                        return new ArrayList().stream();
                    }
                    return ProxyHolder.getInstance().getResourceLoaderManager().loadResources(resourceTypeDefinition).stream();
                }).collect(Collectors.toMap(IResource::getId, Function.identity(), (one, two) -> {
                    throw new IllegalStateException(String.format("The style definition: %s contains two resources with the same key: %s", styleLocation, one.getId()));
                }));
                if (this.styles.containsKey(styleDefinition.getStyleId())) {
                    Log.getLogger().warn("Already existing style detected. Merging and overriding...");
                    IStyle alreadyCreatedStyle = this.styles.remove(styleDefinition.getStyleId());
                    HashMap<IIdentifier, IResource> merged = new HashMap<IIdentifier, IResource>((Map<IIdentifier, IResource>)alreadyCreatedStyle.getResources());
                    resourcesForStyle.forEach((key, value) -> merged.merge((IIdentifier)key, (IResource)value, (one, two) -> two));
                    style = new SimpleStyle(styleDefinition.getStyleId(), merged);
                } else {
                    style = new SimpleStyle(styleDefinition.getStyleId(), resourcesForStyle);
                }
                this.styles.put(styleDefinition.getStyleId(), style);
                IProgressManager.pop((IProgressBar)styleLoadingBar);
            });
            IProgressManager.pop((IProgressBar)domainLoadingBar);
        });
        IProgressManager.pop((IProgressBar)loadingBar);
    }
}

