/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.resources;

import com.google.gson.JsonElement;
import com.ldtteam.blockout.style.core.resources.core.IResource;
import com.ldtteam.blockout.style.core.resources.loader.IResourceLoader;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.item.IItemStack;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.nbt.INBTBase;
import com.ldtteam.jvoxelizer.util.nbt.INBTCompound;
import org.jetbrains.annotations.NotNull;

public class ItemStackResource
implements IResource {
    private final IIdentifier id;
    private final IItemStack stack;

    public ItemStackResource(IIdentifier id, IItemStack stack) {
        this.id = id;
        this.stack = stack;
    }

    @NotNull
    public IIdentifier getId() {
        return this.id;
    }

    public IItemStack getStack() {
        return this.stack.copy();
    }

    public Vector2d getScalingFactor(@NotNull Vector2d targetSize) {
        if (targetSize.getX() == 0.0 || targetSize.getY() == 0.0) {
            return new Vector2d(1.0);
        }
        return new Vector2d(16.0 / targetSize.getX(), 16.0 / targetSize.getY());
    }

    public static final class Loader
    implements IResourceLoader<ItemStackResource> {
        @NotNull
        public String getTypeId() {
            return "itemstack";
        }

        public ItemStackResource load(@NotNull IIdentifier id, @NotNull JsonElement data) {
            try {
                INBTCompound compound = INBTBase.createFromJson((String)data.toString());
                IItemStack stack = IItemStack.create();
                stack.read(compound);
                return new ItemStackResource(id, stack);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("The given NBT for ItemStackResource: %s is not parsable", id), e);
            }
        }
    }
}

