/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.style.core.resources.core.IDiskResource;
import com.ldtteam.blockout.style.core.resources.loader.IResourceLoader;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import org.jetbrains.annotations.NotNull;

public class ImageResource
implements IDiskResource {
    private final IIdentifier diskLocation;
    private final IIdentifier id;
    private final Vector2d size;
    private final Vector2d offset;
    private final Vector2d fileSize;

    public ImageResource(IIdentifier id, IIdentifier diskLocation) {
        this(id, diskLocation, ProxyHolder.getInstance().getImageSize(diskLocation));
    }

    public ImageResource(IIdentifier id, IIdentifier diskLocation, Vector2d size) {
        this(id, diskLocation, size, new Vector2d(), size);
    }

    public ImageResource(IIdentifier id, IIdentifier diskLocation, Vector2d size, Vector2d offset, Vector2d fileSize) {
        this.diskLocation = diskLocation;
        this.id = id;
        this.size = size;
        this.offset = offset;
        this.fileSize = fileSize;
    }

    public static Vector2d getScalingFactory(@NotNull ImageResource resource, Vector2d targetSize) {
        return resource.getScalingFactor(targetSize);
    }

    public Vector2d getScalingFactor(@NotNull Vector2d targetSize) {
        if (targetSize.getX() == 0.0 || targetSize.getY() == 0.0) {
            return new Vector2d(1.0);
        }
        return new Vector2d(targetSize.getX() / this.getSize().getX(), targetSize.getY() / this.getSize().getY());
    }

    public Vector2d getSize() {
        return this.size;
    }

    @NotNull
    public IIdentifier getDiskLocation() {
        return this.diskLocation;
    }

    @NotNull
    public IIdentifier getId() {
        return this.id;
    }

    public Vector2d getOffset() {
        return this.offset;
    }

    public Vector2d getFileSize() {
        return this.fileSize;
    }

    public static final class Loader
    implements IResourceLoader<ImageResource> {
        @NotNull
        public String getTypeId() {
            return "image";
        }

        public ImageResource load(@NotNull IIdentifier id, @NotNull JsonElement data) {
            Vector2d size;
            Vector2d offset;
            if (data.isJsonPrimitive()) {
                String diskLocationPath = data.getAsString();
                IIdentifier diskLocation = IIdentifier.create((String)diskLocationPath);
                return new ImageResource(id, diskLocation);
            }
            if (!data.isJsonObject()) {
                throw new IllegalArgumentException(String.format("Data for ImageResource: %s is not an object or direct file link.", id));
            }
            JsonObject object = data.getAsJsonObject();
            if (!object.has("file") || !object.get("file").isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("File target for ImageResource: %s is not a StringConverter.", id));
            }
            String diskLocationPath = data.getAsString();
            IIdentifier diskLocation = IIdentifier.create((String)diskLocationPath);
            if (object.has("offset") && object.get("offset").isJsonArray()) {
                JsonArray offsetArray = object.get("offset").getAsJsonArray();
                offset = new Vector2d(offsetArray.get(0).getAsDouble(), offsetArray.get(1).getAsDouble());
            } else {
                offset = new Vector2d();
            }
            if (object.has("size") && object.get("size").isJsonArray()) {
                JsonArray sizeArray = object.get("size").getAsJsonArray();
                size = new Vector2d(sizeArray.get(0).getAsDouble(), sizeArray.get(1).getAsDouble());
            } else {
                Vector2d imageSize = ProxyHolder.getInstance().getImageSize(diskLocation);
                size = imageSize.move(offset.invert()).nullifyNegatives();
            }
            return new ImageResource(id, diskLocation, size, offset, size);
        }
    }
}

