/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.render.standard;

import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.render.core.IScissoringController;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.blockout.util.color.IColor;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.client.gui.IScaledResolution;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.DestinationFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.SourceFactor;
import com.ldtteam.jvoxelizer.client.renderer.texture.ISpriteMap;
import java.util.Deque;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public class ScissoringController
implements IScissoringController {
    private static BoundingBox DEBUG_BOX = new BoundingBox();
    private static Random random = new Random(12345L);
    private static int DISPLAYHEIGHT;
    private static int DISPLAYWIDTH;
    private static int GUISCALE;
    @NotNull
    private final Deque<BoundingBox> scissorsQueue = new ConcurrentLinkedDeque<BoundingBox>();
    @NotNull
    private final Deque<IColor> scissorDebugColor = new ConcurrentLinkedDeque<IColor>();
    @NotNull
    private final IRenderingController renderingController;
    private boolean _debugEnabled = false;

    public ScissoringController(@NotNull IRenderingController renderingController) {
        this.renderingController = renderingController;
    }

    public void push(@NotNull BoundingBox box) {
        BoundingBox scissorBox = box.scale(this.renderingController.getRenderingScalingFactor());
        if (!this.scissorsQueue.isEmpty()) {
            scissorBox = scissorBox.intersect(this.scissorsQueue.peekFirst());
            ScissoringController.disableScissor();
        }
        this.scissorsQueue.addFirst(scissorBox);
        this.scissorDebugColor.addFirst(this.generateNewDebugDrawColor());
        ScissoringController.enableScissor(scissorBox);
        if (this._debugEnabled) {
            IOpenGl.pushMatrix();
            IOpenGl.enableAlpha();
            IOpenGl.enableBlend();
            IOpenGl.blendFunc((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA);
            this.renderingController.bindTexture(ISpriteMap.getLocationOfBlocksTexture());
            this.renderingController.drawTexturedModalRect(new Vector2d(-10.0, -10.0), new Vector2d((double)DISPLAYWIDTH, (double)DISPLAYHEIGHT), new Vector2d(), new Vector2d((double)DISPLAYWIDTH, (double)DISPLAYHEIGHT), new Vector2d((double)DISPLAYWIDTH, (double)DISPLAYHEIGHT));
            IOpenGl.disableBlend();
            IOpenGl.disableAlpha();
            IOpenGl.popMatrix();
        }
    }

    private static void disableScissor() {
        IOpenGl.disableScissor();
    }

    @NotNull
    private IColor generateNewDebugDrawColor() {
        IColor color = IColor.create((int)random.nextInt());
        for (int attempts = 0; this.scissorDebugColor.contains(color) && attempts < 100; ++attempts) {
            color = IColor.create((int)random.nextInt());
        }
        return color;
    }

    private static void enableScissor(@NotNull BoundingBox box) {
        ScissoringController.calcScaleFactor();
        IOpenGl.enableScissor((int)((int)(box.getUpperLeftCoordinate().getX() * (double)GUISCALE)), (int)((int)(((double)DISPLAYHEIGHT - box.getUpperRightCoordinate().getY()) * (double)GUISCALE)), (int)((int)(box.getSize().getX() * (double)GUISCALE)), (int)((int)(box.getSize().getY() * (double)GUISCALE)));
    }

    private static void calcScaleFactor() {
        IGameEngine mc = IGameEngine.getInstance();
        IScaledResolution sc = IScaledResolution.create((IGameEngine)mc);
        DISPLAYWIDTH = sc.getScaledWidth();
        DISPLAYHEIGHT = sc.getScaledHeight();
        GUISCALE = sc.getScaleFactor();
        DEBUG_BOX = new BoundingBox(new Vector2d(-10000.0, -10000.0), new Vector2d(20000.0, 20000.0));
    }

    public void pop() {
        if (this.scissorsQueue.isEmpty()) {
            ScissoringController.disableScissor();
            Log.getLogger().error("Cannot pop scissor box from empty stack!");
            return;
        }
        this.scissorsQueue.removeFirst();
        this.scissorDebugColor.removeFirst();
        ScissoringController.disableScissor();
        if (!this.scissorsQueue.isEmpty()) {
            ScissoringController.enableScissor(this.scissorsQueue.peekFirst());
        }
    }

    public void setDebugDrawingEnabled(boolean enabled) {
        this._debugEnabled = enabled;
    }
}

