/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.render.standard;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.simple.Slot;
import com.ldtteam.blockout.gui.BlockOutGuiData;
import com.ldtteam.blockout.management.render.IRenderManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.render.core.IScissoringController;
import com.ldtteam.blockout.render.standard.ScissoringController;
import com.ldtteam.blockout.util.color.IColor;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.biome.IBiome;
import com.ldtteam.jvoxelizer.block.state.IBlockState;
import com.ldtteam.jvoxelizer.client.gui.IGuiContainer;
import com.ldtteam.jvoxelizer.client.renderer.bufferbuilder.IBufferBuilder;
import com.ldtteam.jvoxelizer.client.renderer.font.IFontRenderer;
import com.ldtteam.jvoxelizer.client.renderer.item.IItemRenderer;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.DestinationFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.SourceFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.vertexformat.IVertexFormat;
import com.ldtteam.jvoxelizer.client.renderer.tessellator.ITessellator;
import com.ldtteam.jvoxelizer.client.renderer.texture.ISprite;
import com.ldtteam.jvoxelizer.client.renderer.texture.ISpriteMap;
import com.ldtteam.jvoxelizer.core.logic.DummyInstanceData;
import com.ldtteam.jvoxelizer.dimension.IDimensionReader;
import com.ldtteam.jvoxelizer.dimension.IDimensionType;
import com.ldtteam.jvoxelizer.dimension.logic.builder.IDimensionReaderBuilder;
import com.ldtteam.jvoxelizer.dimension.logic.builder.contexts.GetBlockEntityContext;
import com.ldtteam.jvoxelizer.dimension.logic.builder.contexts.GetBlockStateContext;
import com.ldtteam.jvoxelizer.dimension.logic.builder.contexts.GetCombinedLightContext;
import com.ldtteam.jvoxelizer.dimension.logic.builder.contexts.IsAirBlockContext;
import com.ldtteam.jvoxelizer.dimension.logic.builder.contexts.IsSideSolidContext;
import com.ldtteam.jvoxelizer.fluid.IFluidStack;
import com.ldtteam.jvoxelizer.inventory.IContainer;
import com.ldtteam.jvoxelizer.inventory.slot.ISlot;
import com.ldtteam.jvoxelizer.item.IItemStack;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import com.ldtteam.jvoxelizer.util.textformatting.ITextFormatting;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderingController
implements IRenderingController {
    @NotNull
    private static final IItemRenderer ITEMRENDERER = IGameEngine.getInstance().getItemRenderer();
    @NotNull
    private final IRenderManager renderManager;
    @NotNull
    private final IScissoringController scissoringController = new ScissoringController(this);
    @NotNull
    private Vector2d lastKnownMousePosition = new Vector2d();

    public RenderingController(@NotNull IRenderManager renderManager) {
        this.renderManager = renderManager;
    }

    public Vector2d getRenderingScalingFactor() {
        return this.renderManager.getRenderingScalingFactor();
    }

    public IScissoringController getScissoringController() {
        return this.scissoringController;
    }

    public void bindTexture(@NotNull String textureAddress) {
        this.bindTexture(IIdentifier.create((String)textureAddress));
    }

    public void bindTexture(@NotNull IIdentifier textureLocation) {
        IGameEngine.getInstance().getTextureManager().bindTexture(textureLocation);
    }

    public void drawTexturedModalRect(@NotNull Vector2d origin, @NotNull Vector2d size, @NotNull Vector2d inTexturePosition, @NotNull Vector2d inTextureSize, @NotNull Vector2d textureSize) {
        IOpenGl.pushMatrix();
        IOpenGl.enableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.disableLighting();
        IOpenGl.blendFunc((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA);
        IOpenGl.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double x = origin.getX();
        double y = origin.getY();
        double width = size.getX();
        double height = size.getY();
        double textureX = inTexturePosition.getX();
        double textureY = inTexturePosition.getY();
        double textureWidth = inTextureSize.getX() / textureSize.getX();
        double textureHeight = inTextureSize.getY() / textureSize.getY();
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(7, IVertexFormat.positionTex());
        bufferbuilder.pos(x + 0.0, y + height, 0.0).tex(textureX, textureY + textureHeight).endVertex();
        bufferbuilder.pos(x + width, y + height, 0.0).tex(textureX + textureWidth, textureY + textureHeight).endVertex();
        bufferbuilder.pos(x + width, y + 0.0, 0.0).tex(textureX + textureWidth, textureY).endVertex();
        bufferbuilder.pos(x + 0.0, y + 0.0, 0.0).tex(textureX, textureY).endVertex();
        tessellator.draw();
        IOpenGl.disableBlend();
        IOpenGl.enableAlpha();
        IOpenGl.enableLighting();
        IOpenGl.popMatrix();
    }

    public void drawFluid(@Nullable IFluidStack fluid, int x, int y, int z, int w, int h) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        ISprite texture = IGameEngine.getInstance().getTextureMapBlocks().getSrite(fluid.getFluid().getStill(fluid).toString());
        if (texture == null) {
            texture = IGameEngine.getInstance().getTextureManager().getSpriteMap(ISpriteMap.getLocationOfBlocksTexture()).getSrite("missingno");
        }
        IColor fluidColor = IColor.create((int)fluid.getFluid().getColor(fluid));
        this.bindTexture(ISpriteMap.getLocationOfBlocksTexture());
        fluidColor.performOpenGLColoring();
        int fullX = w / 16 + 1;
        int fullY = h / 16 + 1;
        for (int i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                this.drawCutIcon(texture, x + i * 16, y + j * 16, z, 16, 16, 0);
            }
        }
    }

    public void drawCutIcon(@NotNull ISprite icon, int x, int y, int z, int w, int h, int cutOffVertical) {
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder worldrenderer = tessellator.getBuffer();
        worldrenderer.begin(7, IVertexFormat.positionTex());
        worldrenderer.pos((double)(x + 0), (double)(y + h), (double)z).tex((double)icon.getMinU(), (double)icon.getInterpolatedV((double)h)).endVertex();
        worldrenderer.pos((double)(x + w), (double)(y + h), (double)z).tex((double)icon.getInterpolatedU((double)w), (double)icon.getInterpolatedV((double)h)).endVertex();
        worldrenderer.pos((double)(x + w), (double)(y + 0), (double)z).tex((double)icon.getInterpolatedU((double)w), (double)icon.getInterpolatedV((double)cutOffVertical)).endVertex();
        worldrenderer.pos((double)(x + 0), (double)(y + 0), (double)z).tex((double)icon.getMinU(), (double)icon.getInterpolatedV((double)cutOffVertical)).endVertex();
        tessellator.draw();
    }

    public void drawTexturedModelRectFromIcon(int x, int y, int z, @NotNull ISprite icon, int w, int h) {
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder worldrenderer = tessellator.getBuffer();
        worldrenderer.begin(7, IVertexFormat.positionTex());
        worldrenderer.pos((double)(x + 0), (double)(y + h), (double)z).tex((double)icon.getMinU(), (double)icon.getMaxV()).endVertex();
        worldrenderer.pos((double)(x + w), (double)(y + h), (double)z).tex((double)icon.getMaxU(), (double)icon.getMaxV()).endVertex();
        worldrenderer.pos((double)(x + w), (double)(y + 0), (double)z).tex((double)icon.getMaxU(), (double)icon.getMinV()).endVertex();
        worldrenderer.pos((double)(x + 0), (double)(y + 0), (double)z).tex((double)icon.getMinU(), (double)icon.getMinV()).endVertex();
        tessellator.draw();
    }

    public void drawColoredRect(@NotNull BoundingBox box, int z, @NotNull IColor c) {
        this.drawGradiendColoredRect(box, z, c, c);
    }

    public void drawGradiendColoredRect(@NotNull BoundingBox box, int z, @NotNull IColor colorStart, @NotNull IColor colorEnd) {
        float f = colorStart.getAlphaFloat();
        float f1 = colorStart.getBlueFloat();
        float f2 = colorStart.getGreenFloat();
        float f3 = colorStart.getRedFloat();
        float f4 = colorEnd.getAlphaFloat();
        float f5 = colorEnd.getBlueFloat();
        float f6 = colorEnd.getGreenFloat();
        float f7 = colorEnd.getRedFloat();
        IOpenGl.disableTexture2D();
        IOpenGl.enableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        IOpenGl.shadeModel((int)7425);
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder worldrenderer = tessellator.getBuffer();
        worldrenderer.begin(7, IVertexFormat.positionColor());
        worldrenderer.pos(box.getLowerRightCoordinate().getX(), box.getUpperLeftCoordinate().getY(), (double)z).color(f3, f2, f1, f).endVertex();
        worldrenderer.pos(box.getUpperLeftCoordinate().getX(), box.getUpperLeftCoordinate().getY(), (double)z).color(f3, f2, f1, f).endVertex();
        worldrenderer.pos(box.getUpperLeftCoordinate().getX(), box.getLowerRightCoordinate().getY(), (double)z).color(f7, f6, f5, f4).endVertex();
        worldrenderer.pos(box.getLowerRightCoordinate().getX(), box.getLowerRightCoordinate().getY(), (double)z).color(f7, f6, f5, f4).endVertex();
        tessellator.draw();
        IOpenGl.shadeModel((int)7424);
        IOpenGl.disableBlend();
        IOpenGl.enableAlpha();
        IOpenGl.enableTexture2D();
    }

    public void drawRect(double left, double top, double right, double bottom, @NotNull IColor color) {
        double j;
        double relativeLeft = left;
        double relativeRight = right;
        double relativeTop = top;
        double relativeBottom = bottom;
        if (left < right) {
            j = left;
            relativeLeft = right;
            relativeRight = j;
        }
        if (top < bottom) {
            j = top;
            relativeTop = bottom;
            relativeBottom = j;
        }
        float f = color.getRedFloat();
        float f1 = color.getGreenFloat();
        float f2 = color.getBlueFloat();
        float f3 = color.getAlphaFloat();
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder bufferbuilder = tessellator.getBuffer();
        IOpenGl.enableBlend();
        IOpenGl.disableTexture2D();
        IOpenGl.tryBlendFuncSeparate((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA, (SourceFactor)SourceFactor.ONE, (DestinationFactor)DestinationFactor.ZERO);
        IOpenGl.color((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.begin(7, IVertexFormat.position());
        bufferbuilder.pos(relativeLeft, relativeBottom, 0.0).endVertex();
        bufferbuilder.pos(relativeRight, relativeBottom, 0.0).endVertex();
        bufferbuilder.pos(relativeRight, relativeTop, 0.0).endVertex();
        bufferbuilder.pos(relativeLeft, relativeTop, 0.0).endVertex();
        tessellator.draw();
        IOpenGl.enableTexture2D();
        IOpenGl.disableBlend();
    }

    public void drawItemStack(@NotNull IItemStack stack, int x, int y) {
        IOpenGl.enableLighting();
        IOpenGl.enableDepth();
        IOpenGl.enableStandardItemLighting();
        IFontRenderer font = null;
        if (!stack.isEmpty()) {
            font = stack.getItem().getFontRenderer(stack);
        }
        if (font == null) {
            font = IGameEngine.getInstance().getDefaultFontRenderer();
        }
        ITEMRENDERER.renderItemAndEffectIntoGUI(stack, x, y);
        ITEMRENDERER.renderItemOverlayIntoGUI(font, stack, x, y, "");
        IOpenGl.disableStandardItemLighting();
        IOpenGl.enableDepth();
        IOpenGl.disableLighting();
    }

    public void drawItemStack(@NotNull IItemStack stack, int x, int y, String altText) {
        IOpenGl.enableLighting();
        IOpenGl.enableDepth();
        IOpenGl.enableStandardItemLighting();
        IFontRenderer font = null;
        if (!stack.isEmpty()) {
            font = stack.getItem().getFontRenderer(stack);
        }
        if (font == null) {
            font = IGameEngine.getInstance().getDefaultFontRenderer();
        }
        ITEMRENDERER.renderItemAndEffectIntoGUI(stack, x, y);
        ITEMRENDERER.renderItemOverlayIntoGUI(font, stack, x, y, altText);
        IOpenGl.disableStandardItemLighting();
        IOpenGl.enableDepth();
        IOpenGl.disableLighting();
    }

    public void drawBlockState(@NotNull IBlockState state, int x, int y) {
        block2: {
            IOpenGl.disableStandardItemLighting();
            IDimensionReaderBuilder dimensionReaderBuilder = IDimensionReaderBuilder.create();
            IDimensionReader dimensionReader = dimensionReaderBuilder.GetBlockEntity(new Function[]{context -> {
                if (((GetBlockEntityContext)context.getContext()).getPos().getX() != 0 || ((GetBlockEntityContext)context.getContext()).getPos().getY() != 0 || ((GetBlockEntityContext)context.getContext()).getPos().getZ() != 0) {
                    return null;
                }
                return state.getBlock().createBlockEntity(null, state);
            }}).GetCombinedLight(new Function[]{context -> {
                int i = 15;
                int j = 15;
                if (j < ((GetCombinedLightContext)context.getContext()).getLightValue()) {
                    j = ((GetCombinedLightContext)context.getContext()).getLightValue();
                }
                return i << 20 | j << 4;
            }}).GetBlockState(new Function[]{context -> {
                if (((GetBlockStateContext)context.getContext()).getPos().getX() != 0 || ((GetBlockStateContext)context.getContext()).getPos().getY() != 0 || ((GetBlockStateContext)context.getContext()).getPos().getZ() != 0) {
                    return IBlockState.defaultState();
                }
                return state;
            }}).IsAirBlock(new Function[]{context -> ((IDimensionReader)context.getInstance()).getBlockState(((IsAirBlockContext)context.getContext()).getPos()).getBlock().isAir()}).GetBiome(new Function[]{context -> IBiome.getPlains()}).GetStrongPower(new Function[]{context -> 15}).GetWorldType(new Function[]{context -> IDimensionType.getDefault()}).IsSideSolid(new Function[]{context -> ((IDimensionReader)context.getInstance()).getBlockState(((IsSideSolidContext)context.getContext()).getPos()).isSideSolid((IDimensionReader)context.getInstance(), ((IsSideSolidContext)context.getContext()).getPos(), ((IsSideSolidContext)context.getContext()).getSide())}).build((Object)new DummyInstanceData());
            IOpenGl.pushMatrix();
            IOpenGl.translate((float)0.0f, (float)0.0f, (float)0.0f);
            IOpenGl.scale((float)14.0f, (float)14.0f, (float)-14.0f);
            IOpenGl.rotate((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            IOpenGl.rotate((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IBufferBuilder buf = ITessellator.getInstance().getBuffer();
            buf.begin(IOpenGl.getOpenGlQuadsRenderMode(), IVertexFormat.block());
            try {
                IGameEngine.getInstance().getBlockRendererDispatcher().renderBlock(state, IBlockCoordinate.create((int)0, (int)0, (int)0), dimensionReader, buf);
            }
            catch (Throwable t) {
                if (!(t instanceof VirtualMachineError) && !(t instanceof LinkageError)) break block2;
                throw (Error)t;
            }
        }
        ITessellator.getInstance().draw();
        IOpenGl.popMatrix();
    }

    public void drawSlotContent(@NotNull IUIElement element) {
        ISprite textureatlassprite;
        if (!(element instanceof Slot)) {
            return;
        }
        Slot slot = (Slot)element;
        IGuiContainer gui = (IGuiContainer)IGameEngine.getInstance().getCurrentGui();
        int x = 1;
        int y = 1;
        IIdentifier inventoryId = slot.getInventoryId();
        int inventoryIndex = slot.getInventoryIndex();
        IItemStack itemstack = ((BlockOutGuiData)gui.getInstanceData()).getKey().getItemHandlerManager().getItemHandlerFromId(inventoryId).getStackInSlot(inventoryIndex);
        ISlot slotIn = gui.getContainer().getSlotById(slot.getSlotIndex());
        boolean flag = false;
        boolean isDraggingStartSlot = slotIn == gui.getClickedSlot() && !gui.getDraggedStack().isEmpty() && !gui.isRightMouseClicked();
        IItemStack itemstack1 = gui.getGameEngine().getSinglePlayerPlayerEntity().getInventory().getItemStack();
        String s = null;
        if (slotIn == gui.getClickedSlot() && !gui.getDraggedStack().isEmpty() && gui.isRightMouseClicked() && !itemstack.isEmpty()) {
            itemstack = itemstack.copy();
            itemstack.setCount(itemstack.getCount() / 2);
        } else if (gui.isDragSplitting() && gui.getSlotsUsedInDragSplitting().contains(slotIn) && !itemstack1.isEmpty()) {
            if (gui.getSlotsUsedInDragSplitting().size() == 1) {
                return;
            }
            if (IContainer.canAddItemToSlot((ISlot)slotIn, (IItemStack)itemstack1, (boolean)true) && gui.getContainer().canDragIntoSlot(slotIn)) {
                itemstack = itemstack1.copy();
                flag = true;
                IContainer.computeStackSize((List)gui.getSlotsUsedInDragSplitting(), (int)gui.getDragSplittingLimit(), (IItemStack)itemstack, (int)(slotIn.getContainedStack().isEmpty() ? 0 : slotIn.getContainedStack().getCount()));
                int k = Math.min(itemstack.getMaxStackSize(), slotIn.getItemStackLimit(itemstack));
                if (itemstack.getCount() > k) {
                    s = ITextFormatting.yellow().toString() + k;
                    itemstack.setCount(k);
                }
            } else {
                gui.getSlotsUsedInDragSplitting().remove(slotIn);
                gui.updateDragSplitting();
            }
        }
        gui.getItemRenderer().setZLevel(100.0f);
        if (itemstack.isEmpty() && slotIn.isEnabled() && (textureatlassprite = slotIn.getBackgroundTexture()) != null) {
            IOpenGl.disableLighting();
            gui.getGameEngine().getTextureManager().bindTexture(slotIn.getIdentifierOfBackgroundLocation());
            gui.drawTexturedModalRect(x, y, textureatlassprite, 16, 16);
            IOpenGl.enableLighting();
            isDraggingStartSlot = true;
        }
        if (!isDraggingStartSlot) {
            if (flag) {
                this.drawRect(x, y, x + 16, y + 16, IColor.create((int)-2130706433));
            }
            IOpenGl.enableDepth();
            this.drawItemStack(itemstack, x, y, s);
        }
        gui.getItemRenderer().setZLevel(0.0f);
    }

    public void drawSlotMouseOverlay(@NotNull IUIElement element) {
        if (!(element instanceof Slot)) {
            return;
        }
        Slot slot = (Slot)element;
        IGuiContainer gui = (IGuiContainer)IGameEngine.getInstance().getCurrentGui();
        if (!slot.getAbsoluteBoundingBox().includes(this.getMousePosition())) {
            return;
        }
        gui.setHoveredSlot(gui.getContainer().getSlotById(slot.getSlotIndex()));
        IOpenGl.disableLighting();
        IOpenGl.disableDepth();
        int x = 1;
        int y = 1;
        IOpenGl.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.drawGradientRect(0, x, y, x + 16, y + 16, -2130706433, -2130706433);
        IOpenGl.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        IOpenGl.enableLighting();
        IOpenGl.enableDepth();
    }

    public void drawGradientRect(int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        IOpenGl.disableTexture2D();
        IOpenGl.enableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.tryBlendFuncSeparate((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA, (SourceFactor)SourceFactor.ONE, (DestinationFactor)DestinationFactor.ZERO);
        IOpenGl.shadeModel((int)7425);
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(7, IVertexFormat.positionColor());
        bufferbuilder.pos((double)right, (double)top, (double)zLevel).color(f1, f2, f3, f).endVertex();
        bufferbuilder.pos((double)left, (double)top, (double)zLevel).color(f1, f2, f3, f).endVertex();
        bufferbuilder.pos((double)left, (double)bottom, (double)zLevel).color(f5, f6, f7, f4).endVertex();
        bufferbuilder.pos((double)right, (double)bottom, (double)zLevel).color(f5, f6, f7, f4).endVertex();
        tessellator.draw();
        IOpenGl.shadeModel((int)7424);
        IOpenGl.disableBlend();
        IOpenGl.enableAlpha();
        IOpenGl.enableTexture2D();
    }

    public Vector2d getMousePosition() {
        return this.lastKnownMousePosition;
    }

    public void setMousePosition(@NotNull Vector2d mousePosition) {
        this.lastKnownMousePosition = mousePosition;
    }
}

