/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.reflection;

import com.esotericsoftware.reflectasm.FieldAccess;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ldtteam.blockout.reflection.FieldReflectionEntry;
import com.ldtteam.blockout.reflection.IFieldReflectionEntry;
import com.ldtteam.blockout.reflection.IReflectionManager;
import com.ldtteam.blockout.util.Log;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class ReflectionManager
implements IReflectionManager {
    private static ReflectionManager ourInstance = new ReflectionManager();
    private final Cache<Class<?>, Set<IFieldReflectionEntry>> FIELD_CACHE = CacheBuilder.newBuilder().maximumSize(1000000L).build();
    private final Cache<Class<?>, Set<Class<?>>> SUPERS_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).build();

    private ReflectionManager() {
    }

    public static ReflectionManager getInstance() {
        return ourInstance;
    }

    public Set<IFieldReflectionEntry> getFieldsForClass(Class<?> clz) {
        try {
            return (Set)this.FIELD_CACHE.get(clz, () -> this.buildFieldCacheForClass(clz));
        }
        catch (ExecutionException e) {
            Log.getLogger().error("Failed to build field cache for class: " + clz.getName() + ", aborted.", (Throwable)e);
            return Sets.newHashSet();
        }
    }

    public <A> Set<Class<? super A>> getAllSupers(Class<? super A> clz) {
        try {
            return ((Set)this.SUPERS_CACHE.get(clz, () -> this.getAllSupersInternal(clz))).stream().map(c -> c).collect(Collectors.toSet());
        }
        catch (ExecutionException e) {
            Log.getLogger().error("Failed to retrieve all supers of: " + clz.getName());
            return ImmutableSet.of(clz, Object.class);
        }
    }

    private Set<Class<?>> getAllSupersInternal(Class<?> clz) {
        if (clz == Object.class) {
            return ImmutableSet.of(Object.class);
        }
        HashSet supers = Sets.newHashSet();
        supers.addAll(this.getAllSupersInternal(clz.getSuperclass()));
        Arrays.stream(clz.getInterfaces()).forEach(i -> supers.addAll(this.getAllSupersInternal((Class<?>)i)));
        supers.add(clz);
        return supers;
    }

    private Set<IFieldReflectionEntry> buildFieldCacheForClass(Class<?> clz) {
        FieldAccess access = FieldAccess.get(clz);
        String[] fieldNames = access.getFieldNames();
        Class[] fieldTypes = access.getFieldTypes();
        HashSet entries = Sets.newHashSet();
        for (int i = 0; i < access.getFieldCount(); ++i) {
            entries.add(new FieldReflectionEntry(access, fieldNames[i], i, fieldTypes[i]));
        }
        return entries;
    }
}

