/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.network.message;

import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.element.simple.TextField;
import com.ldtteam.blockout.network.message.core.IBlockOutClientToServerMessage;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.jvoxelizer.entity.living.player.IMultiplayerPlayerEntity;
import com.ldtteam.jvoxelizer.entity.living.player.IPlayerEntity;
import com.ldtteam.jvoxelizer.networking.messaging.IMessageContext;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class TextFieldUpdateContentsMessage
implements IBlockOutClientToServerMessage {
    private String controlId;
    private String newContent;

    public TextFieldUpdateContentsMessage(String controlId, String newContent) {
        this.controlId = controlId;
        this.newContent = newContent;
    }

    public TextFieldUpdateContentsMessage() {
    }

    @Override
    public void onMessageArrivalAtServer(@NotNull IMessageContext ctx) {
        IMultiplayerPlayerEntity playerMP = ctx.getSendingPlayer();
        IGuiKey guiKey = ProxyHolder.getInstance().getGuiController().getOpenUI((IPlayerEntity)playerMP);
        if (guiKey == null) {
            return;
        }
        RootGuiElement rootGuiElement = (RootGuiElement)ProxyHolder.getInstance().getGuiController().getRoot(guiKey);
        Optional optionalTextBox = rootGuiElement.searchExactElementById(this.controlId, TextField.class);
        optionalTextBox.ifPresent(textBox -> {
            textBox.setContents(this.newContent);
            textBox.raiseOnContentChanged();
        });
    }
}

