/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.network.message;

import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.gui.BlockOutGuiData;
import com.ldtteam.blockout.gui.BlockOutGuiLogic;
import com.ldtteam.blockout.inventory.BlockOutContainerData;
import com.ldtteam.blockout.inventory.BlockOutContainerLogic;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.management.UIManager;
import com.ldtteam.blockout.network.message.core.IBlockOutServerToClientMessage;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.client.gui.IGuiContainer;
import com.ldtteam.jvoxelizer.inventory.IContainer;
import com.ldtteam.jvoxelizer.networking.messaging.IMessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenGuiCommandMessage
implements IBlockOutServerToClientMessage {
    @NotNull
    private IGuiKey key;
    @NotNull
    private IUIElementData data;
    @NotNull
    private int windowId;

    public OpenGuiCommandMessage() {
    }

    public OpenGuiCommandMessage(@NotNull IGuiKey key, @NotNull IUIElementData data, @NotNull int windowId) {
        this.key = key;
        this.data = data;
        this.windowId = windowId;
    }

    @Override
    @Nullable
    public void onMessageArrivalAtClient(@NotNull IMessageContext ctx) {
        IUIElement element = ProxyHolder.getInstance().getFactoryController().getElementFromData(this.getData());
        if (!(element instanceof RootGuiElement)) {
            throw new IllegalStateException("Root element is not a RootGuiElement");
        }
        RootGuiElement root = (RootGuiElement)element;
        root.setUiManager(new UIManager(root, this.getKey()));
        root.getUiManager().getUpdateManager().updateElement((IUIElement)root);
        IContainer<BlockOutContainerData> container = BlockOutContainerLogic.create(this.getKey(), (IUIElementHost)root, this.getWindowId());
        IGuiContainer<BlockOutGuiData> blockOutGuiDataIGuiContainer = BlockOutGuiLogic.create(this.getKey(), (IUIElementHost)root, container);
        IGameEngine.getInstance().displayGuiScreen(blockOutGuiDataIGuiContainer);
    }

    @NotNull
    public IUIElementData getData() {
        return this.data;
    }

    @NotNull
    public IGuiKey getKey() {
        return this.key;
    }

    @NotNull
    public int getWindowId() {
        return this.windowId;
    }
}

