/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.network;

import com.ldtteam.blockout.network.BlockOutNetworkMessageWrapper;
import com.ldtteam.blockout.network.message.core.IBlockOutClientToServerMessage;
import com.ldtteam.blockout.network.message.core.IBlockOutServerToClientMessage;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.entity.living.player.IMultiplayerPlayerEntity;
import com.ldtteam.jvoxelizer.networking.endpoint.INetworkEndpoint;
import com.ldtteam.jvoxelizer.networking.messaging.IMessage;
import com.ldtteam.jvoxelizer.networking.messaging.IMessageContext;
import com.ldtteam.jvoxelizer.networking.utils.target.INetworkTargetPoint;
import com.ldtteam.jvoxelizer.threading.IExecutor;
import java.util.UUID;

public class NetworkManager {
    private static INetworkEndpoint network;

    public static void init() {
        network = INetworkEndpoint.create((String)"blockout:network");
    }

    public static void sendToAll(IBlockOutServerToClientMessage message) {
        if (network == null) {
            return;
        }
        network.sendToAll((IMessage)new BlockOutNetworkMessageWrapper(message));
    }

    public static void sendTo(IBlockOutServerToClientMessage message, UUID uuid) {
        NetworkManager.sendTo(message, IGameEngine.getInstance().getCurrentServerInstance().getPlayerManager().getById(uuid));
    }

    public static void sendTo(IBlockOutServerToClientMessage message, IMultiplayerPlayerEntity player) {
        if (network == null) {
            return;
        }
        network.sendTo((IMessage)new BlockOutNetworkMessageWrapper(message), player);
    }

    public static void sendToAllAround(IBlockOutServerToClientMessage message, INetworkTargetPoint point) {
        if (network == null) {
            return;
        }
        network.sendToAllAround((IMessage)new BlockOutNetworkMessageWrapper(message), point);
    }

    public static void sendToDimension(IBlockOutServerToClientMessage message, int dimensionId) {
        if (network == null) {
            return;
        }
        network.sendToDimension((IMessage)new BlockOutNetworkMessageWrapper(message), dimensionId);
    }

    public static void sendToServer(IBlockOutClientToServerMessage message) {
        if (network == null) {
            return;
        }
        network.sendToServer((IMessage)new BlockOutNetworkMessageWrapper(message));
    }

    public static IExecutor getExecutor(IMessageContext context) {
        if (network == null) {
            return null;
        }
        return network.getExecutorFromContext(context);
    }
}

