/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.network;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.ldtteam.blockout.network.message.core.IBlockOutNetworkMessage;
import com.ldtteam.blockout.util.kryo.KryoUtil;
import com.ldtteam.jvoxelizer.networking.messaging.IMessage;
import com.ldtteam.jvoxelizer.networking.messaging.IMessageContext;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class BlockOutNetworkMessageWrapper
implements IMessage {
    private final Kryo KRYO = KryoUtil.createNewKryo();
    private boolean loaded = false;
    private IBlockOutNetworkMessage message;

    public BlockOutNetworkMessageWrapper() {
    }

    public BlockOutNetworkMessageWrapper(IBlockOutNetworkMessage message) {
        this.message = message;
    }

    public void fromBytes(ByteBuf buf) {
        ByteBuf localBuffer = buf.retain();
        int length = localBuffer.readInt();
        if (length > 0) {
            byte[] data = new byte[localBuffer.readableBytes()];
            buf.readBytes(data);
            Input kryoInput = new Input(data);
            this.message = (IBlockOutNetworkMessage)this.KRYO.readClassAndObject(kryoInput);
            this.loaded = true;
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        Output kryoOutput = new Output((OutputStream)arrayOutputStream);
        this.KRYO.writeClassAndObject(kryoOutput, (Object)this.message);
        kryoOutput.close();
        byte[] data = arrayOutputStream.toByteArray();
        buf.writeInt(data.length);
        buf.writeBytes(data);
    }

    public void onArrived(IMessageContext iMessageContext) {
        if (this.loaded) {
            this.message.onMessage(iMessageContext);
        }
    }
}

